<?php
session_start();
require_once __DIR__ . '/../config/database.php';
$uploadDir = __DIR__ . '/../uploads/photo_album/';
if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);

$response = ['uploaded' => []];

$userId = $_SESSION['user_id'] ?? 'unknown';
$indexNumber = 'unknown';
if ($userId !== 'unknown') {
    $stmt = $pdo->prepare('SELECT index_number FROM users WHERE id = ?');
    $stmt->execute([$userId]);
    $user = $stmt->fetch();
    if ($user && isset($user['index_number'])) {
        $indexNumber = $user['index_number'];
    }
}

if (!empty($_FILES['photos'])) {
    $idx = 1;
    foreach ($_FILES['photos']['tmp_name'] as $i => $tmp) {
        $ext = pathinfo($_FILES['photos']['name'][$i], PATHINFO_EXTENSION);
        $name = $indexNumber . '_report_' . $idx . '.' . $ext;
        if (move_uploaded_file($tmp, $uploadDir . $name)) {
            $response['uploaded'][] = $name;
        }
        $idx++;
    }
}

header('Content-Type: application/json');
echo json_encode($response);
