<?php include '../includes/header.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <title>Login - Internship Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(to right, #ece9e6, #ffffff);
            font-family: 'Arial', sans-serif;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            margin: 0;
        }

        .container {
            flex: 1;
            padding-bottom: 2rem; /* Add padding to ensure space between the card and the footer */
        }

        .card {
            border: none;
            border-radius: 0; /* Remove rounded corners */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            transition: transform 0.2s;
        }

        .card:hover {
            transform: scale(1.02);
        }

        .card-body {
            background-color: #fff;
            padding: 2rem;
        }

        .card h1, .card h2 {
            color: #173485;
        }

        .card a {
            color: #1e429c;
            text-decoration: none;
        }

        .card a:hover {
            text-decoration: underline;
        }

        ul {
            list-style-type: none;
            padding-left: 0;
        }

        ul li {
            padding: 0.5rem 0;
        }

        .btn {
            border-radius: 0; /* Remove rounded corners from buttons */
        }

        .input-group-text {
            border-radius: 0; /* Remove rounded corners from input group text */
        }

        @media (max-width: 768px) {
            .card-body {
                padding: 1rem;
            }
            .container {
                padding-top: 1rem;
            }
            .card h1, .card h2 {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="container d-flex justify-content-center align-items-center" style="min-height: 100vh;">
        <div class="card p-4" style="width: 100%; max-width: 400px;">
            <h2 class="card-title text-center">Login</h2>
            <?php if (isset($_GET['error']) && htmlspecialchars($_GET['error']) === 'invalid_credentials'): ?>
                <div class="alert alert-danger text-center" role="alert" id="errorAlert">
                    Invalid index number or password. Please try again.
                </div>
            <?php endif; ?>
            <form method="POST" action="login_action">
                <div class="mb-3">
                    <label for="indexNumber" class="form-label">Index Number</label>
                    <input type="text" class="form-control" id="indexNumber" name="indexNumber" required>
                </div>
                <div class="mb-3">
                    <label for="password" class="form-label">Password</label>
                    <div class="input-group">
                        <input type="password" class="form-control" id="password" name="password" required>
                        <span class="input-group-text" id="togglePassword" style="cursor: pointer;"><i class="fas fa-eye"></i></span>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary w-100"><i class="fas fa-sign-in-alt"></i> Login</button>
            </form>
            <div class="mt-3 d-flex justify-content-between">
                <a href="forgot_password" class="btn btn-link">Forgot Password?</a>
                <a href="register" class="btn btn-link">Create an account</a>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const errorAlert = document.getElementById('errorAlert');
            if (errorAlert) {
                setTimeout(() => {
                    errorAlert.style.display = 'none';
                }, 60000); // 60000 milliseconds = 1 minute
            }

            const togglePassword = document.getElementById('togglePassword');
            const password = document.getElementById('password');
            togglePassword.addEventListener('click', function (e) {
                // toggle the type attribute
                const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
                password.setAttribute('type', type);
                // toggle the eye / eye slash icon
                this.querySelector('i').classList.toggle('fa-eye');
                this.querySelector('i').classList.toggle('fa-eye-slash');
            });
        });
    </script>

    <?php include '../includes/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/js/all.min.js"></script>
</body>
</html>
