<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login');
    exit;
}
include '../includes/header.php';
include '../config/database.php';

$statusMessage = '';
if (isset($_GET['status'])) {
    if ($_GET['status'] === 'submitted') {
        $statusMessage = 'Your details have been submitted.';
    } elseif ($_GET['status'] === 'saved') {
        $statusMessage = 'Your details have been saved. You can continue later.';
    } elseif ($_GET['status'] === 'error_upload') {
        $statusMessage = 'There was an error uploading your file. Please try again.';
    } elseif ($_GET['status'] === 'invalid_file_type') {
        $statusMessage = 'Invalid file type. Only PDF and image files (JPG, PNG) are allowed.';
    }
}

// Fetch the logged-in user's group and existing details if any
$userId = $_SESSION['user_id'];
$stmt = $pdo->prepare('SELECT `group`, (SELECT status FROM student_details WHERE user_id = ?) AS submission_status FROM users WHERE id = ?');
$stmt->execute([$userId, $userId]);
$user = $stmt->fetch();
$group = htmlspecialchars($user['group'], ENT_QUOTES, 'UTF-8');
$submissionStatus = htmlspecialchars($user['submission_status'], ENT_QUOTES, 'UTF-8');

$isSubmitted = $submissionStatus === 'submitted';
$isSaved     = $submissionStatus === 'saved';

$lecturerName = '';
if ($isSaved || $isSubmitted) {
    $stmt = $pdo->prepare('SELECT * FROM student_details WHERE user_id = ?');
    $stmt->execute([$userId]);
    $studentDetails = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!empty($studentDetails['lecturer_id'])) {
        $stmt = $pdo->prepare('SELECT name FROM lecturer_login WHERE id = ?');
        $stmt->execute([$studentDetails['lecturer_id']]);
        $lecturer = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($lecturer) {
            $lecturerName = htmlspecialchars($lecturer['name'], ENT_QUOTES, 'UTF-8');
        }
    }
} else {
    $studentDetails = [
        'surname'           => '',
        'first_name'        => '',
        'other_names'       => '',
        'telephone'         => '',
        'email'             => '',
        'course'            => '',
        'organisation_name' => '',
        'months'            => '',
        'location'          => '',
        'gps_location'      => '',
        'region'            => '',
        'district'          => '',
        'acceptance_letter' => ''
    ];
}

// Fetch regions from the database
$stmt = $pdo->prepare('SELECT DISTINCT region FROM districts');
$stmt->execute();
$regions = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Define courses of study based on the group
$courses = [];
if ($group === 'Industrial Internship') {
    $courses = [
        'Accounting',
        'Procurement and Supply Chain Management',
        'Business Information Systems',
        'Human Resource Management',
        'Banking and Finance',
        'Insurance and Risk Management',
        'Marketing and Entrepreneurship'
    ];
} elseif ($group === 'Teaching Practice') {
    $courses = [
        'Management Education',
        'Accounting Education'
    ];
}
?>

<!-- Inline styling for dashboard elements -->
<style>
  .btn-custom {
      background-color: #007bff;
      color: white !important;
      border: none;
      border-radius: 0;
      padding: 10px 20px;
      font-size: 16px;
      margin: 4px 2px;
      cursor: pointer;
      box-shadow: 0 2px 4px rgba(0,0,0,0.2);
      transition: background-color 0.3s, box-shadow 0.3s;
  }
  .btn-custom:hover {
      background-color: #0056b3;
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
  }
  .swipe-button-container {
      margin-top: 20px;
  }
  .supervisor-name {
      margin-top: 15px;
      text-align: center;
      font-size: 18px;
      color: #007bff;
      font-weight: bold;
  }
  @media (max-width: 576px) {
      .supervisor-name {
          font-size: 16px;
      }
  }
  @media (max-width: 480px) {
      h2, h4 {
          font-size: 1.5rem;
      }
      .btn-custom {
          font-size: 14px;
          padding: 8px 16px;
      }
  }
</style>

<div class="container mt-4">
  <?php if ($statusMessage): ?>
      <div class="alert alert-info" id="statusMessage">
          <?php echo htmlspecialchars($statusMessage, ENT_QUOTES, 'UTF-8'); ?>
      </div>
  <?php endif; ?>

  <form method="POST" action="save_student_details" enctype="multipart/form-data" id="studentForm">
    <div class="row justify-content-center">
      <div class="col-md-8 col-lg-6">
          <h2>University of Education, Winneba</h2>
          <h4>School of Business.</h4>

          <?php if ($isSubmitted): ?>
              <div class="card mb-4">
                  <div class="card-header">
                      <h3>Download Supervisor's Evaluation Form</h3>
                  </div>
                  <div class="card-body text-center">
                      <a href="download_evaluation" class="btn btn-custom">
                          <i class="fas fa-download"></i> Download
                      </a>
                  </div>
              </div>
              <div class="swipe-button-container text-center">
                  <a href="<?php echo $group === 'Industrial Internship' ? 'internship_report.php' : 'teaching_report.php'; ?>" class="btn btn-custom" id="goToReportButton">
                      <?php if ($group === 'Industrial Internship'): ?>
                         Click to submit Report </i>
                      <?php else: ?>
                          Click to Submit Report <i class="fas fa-arrow-right"></i>
                      <?php endif; ?>
                  </a>
              </div>
              <?php if ($lecturerName): ?>
                  <div class="supervisor-name">
                      Supervisor: <?php echo $lecturerName; ?>
                  </div>
              <?php endif; ?>
          <?php else: ?>
              <!-- Student's Details Card -->
              <div class="card mb-4">
                  <div class="card-header">
                      <h3>Student's Details</h3>
                  </div>
                  <div class="card-body">
                      <fieldset>
                          <!-- Surname -->
                          <div class="mb-3">
                              <label for="surname" class="form-label">Surname</label>
                              <input type="text" class="form-control" id="surname" name="surname"
                                     value="<?php echo htmlspecialchars($studentDetails['surname'], ENT_QUOTES, 'UTF-8'); ?>"
                                     required>
                          </div>
                          <!-- First Name -->
                          <div class="mb-3">
                              <label for="firstName" class="form-label">First Name</label>
                              <input type="text" class="form-control" id="firstName" name="firstName"
                                     value="<?php echo htmlspecialchars($studentDetails['first_name'], ENT_QUOTES, 'UTF-8'); ?>"
                                     required>
                          </div>
                          <!-- Other Names -->
                          <div class="mb-3">
                              <label for="otherNames" class="form-label">Other Names</label>
                              <input type="text" class="form-control" id="otherNames" name="otherNames"
                                     value="<?php echo htmlspecialchars($studentDetails['other_names'], ENT_QUOTES, 'UTF-8'); ?>">
                          </div>
                          <!-- Telephone -->
                          <div class="mb-3">
                              <label for="telephone" class="form-label">Telephone Number</label>
                              <input type="tel" class="form-control" id="telephone" name="telephone" pattern="[0-9]{10,}"
                                     value="<?php echo htmlspecialchars($studentDetails['telephone'], ENT_QUOTES, 'UTF-8'); ?>"
                                     required>
                          </div>
                          <!-- Email -->
                          <div class="mb-3">
                              <label for="email" class="form-label">Email</label>
                              <input type="email" class="form-control" id="email" name="email"
                                     value="<?php echo htmlspecialchars($studentDetails['email'], ENT_QUOTES, 'UTF-8'); ?>"
                                     required>
                          </div>
                          <!-- Course -->
                          <div class="mb-3">
                              <label for="course" class="form-label">Course of Study</label>
                              <select class="form-control" id="course" name="course" required>
                                  <option value="">Select Course</option>
                                  <?php foreach ($courses as $course): ?>
                                      <option value="<?php echo htmlspecialchars($course, ENT_QUOTES, 'UTF-8'); ?>"
                                          <?php echo $studentDetails['course'] === $course ? 'selected' : ''; ?>>
                                          <?php echo htmlspecialchars($course, ENT_QUOTES, 'UTF-8'); ?>
                                      </option>
                                  <?php endforeach; ?>
                              </select>
                          </div>
                      </fieldset>
                  </div>
              </div>

              <!-- Organisation/School Card -->
              <div class="card mb-4">
                  <div class="card-header">
                      <h3><?php echo $group === 'Industrial Internship' ? 'Organisation' : 'School'; ?></h3>
                  </div>
                  <div class="card-body">
                      <fieldset>
                          <!-- Name -->  
                          <div class="mb-3">
                              <label for="organisationName" class="form-label">
                                  <?php echo $group === 'Industrial Internship' ? 'Name of Organisation' : 'Name of School'; ?>
                              </label>
                              <input type="text" class="form-control" id="organisationName" name="organisationName"
                                     value="<?php echo htmlspecialchars($studentDetails['organisation_name'], ENT_QUOTES, 'UTF-8'); ?>"
                                     required>
                          </div>
                          <!-- Months -->
                          <div class="mb-3">
                              <label for="months" class="form-label">Number of Months</label>
                              <select class="form-control" id="months" name="months" required>
                                  <option value="">Select Months</option>
                                  <?php for ($i = 1; $i <= 6; $i++): ?>
                                      <option value="<?php echo $i; ?>"
                                          <?php echo $studentDetails['months'] == $i ? 'selected' : ''; ?>>
                                          <?php echo $i . ' month' . ($i > 1 ? 's' : ''); ?>
                                      </option>
                                  <?php endfor; ?>
                              </select>
                          </div>
                          <!-- Location -->
                          <div class="mb-3">
                              <label for="location" class="form-label">
                                  <?php echo $group === 'Industrial Internship' ? 'Location of Organisation' : 'Location of School'; ?>
                              </label>
                              <input type="text" class="form-control" id="location" name="location"
                                     value="<?php echo htmlspecialchars($studentDetails['location'], ENT_QUOTES, 'UTF-8'); ?>"
                                     required>
                          </div>
                          <!-- GPS Location -->
                          <div class="mb-3">
                              <label for="gpsLocation" class="form-label">
                                  Ghana Post GPS /
                                  <a href="https://www.google.com/maps/" target="_blank">Google location</a>
                              </label>
                              <input type="text" class="form-control" id="gpsLocation" name="gpsLocation"
                                     value="<?php echo htmlspecialchars($studentDetails['gps_location'], ENT_QUOTES, 'UTF-8'); ?>"
                                     required>
                          </div>
                          <!-- Region & District -->
                          <div class="mb-3">
                              <label for="region" class="form-label">Region</label>
                              <select class="form-control" id="region" name="region" required>
                                  <option value="">Select Region</option>
                                  <?php foreach ($regions as $region): ?>
                                      <option value="<?php echo htmlspecialchars($region['region'], ENT_QUOTES, 'UTF-8'); ?>"
                                          <?php echo $studentDetails['region'] === $region['region'] ? 'selected' : ''; ?>>
                                          <?php echo htmlspecialchars($region['region'], ENT_QUOTES, 'UTF-8'); ?>
                                      </option>
                                  <?php endforeach; ?>
                              </select>
                          </div>
                          <div class="mb-3">
                              <label for="district" class="form-label">District</label>
                              <select class="form-control" id="district" name="district" required>
                                  <option value="">Select District</option>
                                  <?php if ($studentDetails['region']): ?>
                                      <?php
                                      $dStmt = $pdo->prepare('SELECT district FROM districts WHERE region = ?');
                                      $dStmt->execute([$studentDetails['region']]);
                                      foreach ($dStmt->fetchAll() as $d): ?>
                                          <option value="<?php echo htmlspecialchars($d['district'], ENT_QUOTES, 'UTF-8'); ?>"
                                              <?php echo $studentDetails['district'] === $d['district'] ? 'selected' : ''; ?>>
                                              <?php echo htmlspecialchars($d['district'], ENT_QUOTES, 'UTF-8'); ?>
                                          </option>
                                      <?php endforeach; ?>
                                  <?php endif; ?>
                              </select>
                          </div>
                          <!-- Acceptance Letter -->
                          <div class="mb-3">
                              <label for="acceptanceLetter" class="form-label">Upload Acceptance Letter</label>
                              <input type="file" class="form-control" id="acceptanceLetter" name="acceptanceLetter"
                                     accept=".pdf, .jpg, .jpeg, .png" required>
                              <?php if ($studentDetails['acceptance_letter']): ?>
                                  <p>Current file: <?php echo htmlspecialchars(basename($studentDetails['acceptance_letter']), ENT_QUOTES, 'UTF-8'); ?></p>
                              <?php endif; ?>
                          </div>
                          <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                              <button type="submit" name="submit" class="btn btn-primary" style="border-radius: 0;">
                                  Submit
                              </button>
                          </div>
                      </fieldset>
                  </div>
              </div>
          <?php endif; ?>
      </div>
    </div>
  </form>
</div>

<!-- JavaScript to auto-populate districts based on selected region -->
<script>
document.getElementById('region').addEventListener('change', function() {
    var selectedRegion = this.value;
    var districtSelect = document.getElementById('district');
    districtSelect.innerHTML = '<option value="">Select District</option>';
    if (!selectedRegion) return;
    var xhr = new XMLHttpRequest();
    xhr.open('GET', 'fetch_districts.php?region=' + encodeURIComponent(selectedRegion), true);
    xhr.onload = function() {
        if (xhr.status === 200) {
            JSON.parse(xhr.responseText).forEach(function(item) {
                var opt = document.createElement('option');
                opt.value = item.district;
                opt.textContent = item.district;
                districtSelect.appendChild(opt);
            });
        }
    };
    xhr.send();
});
</script>

<?php include '../includes/footer.php'; ?>
