<?php
session_start();
include '../config/database.php';

// Function to encrypt a message
function encryptMessage($message, $key, $iv) {
    return openssl_encrypt($message, 'aes-256-cbc', $key, 0, $iv);
}

// Fetch the encryption key and IV from environment variables
$key = base64_decode(getenv('ENCRYPTION_KEY')); // Securely retrieve and decode the key
$iv = base64_decode(getenv('ENCRYPTION_IV')); // Securely retrieve and decode the IV

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Retrieve form data
    $recipients = $_POST['recipients'];
    $subject = $_POST['subject'];
    $message = $_POST['message'];
    $sendToAll = isset($_POST['send_to_all']) ? $_POST['send_to_all'] : 0;

    // Encrypt the message before saving
    $encryptedMessage = encryptMessage($message, $key, $iv);

    // Logic to send the message
    if ($sendToAll) {
        // Send to all students assigned to the lecturer
        $stmt = $pdo->prepare('SELECT user_id FROM student_details WHERE lecturer_id = ?');
        $stmt->execute([$_SESSION['lecturer_id']]);
        $students = $stmt->fetchAll();

        foreach ($students as $student) {
            $stmt = $pdo->prepare('INSERT INTO messages (user_id, sender_id, subject, message) VALUES (?, ?, ?, ?)');
            $stmt->execute([$student['user_id'], $_SESSION['lecturer_id'], $subject, $encryptedMessage]); // Save encrypted message
        }
    } else {
        // Send to selected recipients
        foreach ($recipients as $recipient) {
            $stmt = $pdo->prepare('INSERT INTO messages (user_id, sender_id, subject, message) VALUES (?, ?, ?, ?)');
            $stmt->execute([$recipient, $_SESSION['lecturer_id'], $subject, $encryptedMessage]); // Save encrypted message
        }
    }

    // Set the success message in the session
    $_SESSION['success'] = "Message sent successfully!";
    header('Location: index.php');  // Redirect to the dashboard or another page
    exit();
} else {
    $_SESSION['error'] = "Failed to send message.";
    header('Location: index.php');
    exit();
}
?>
