<?php
session_start();
if (!isset($_SESSION['lecturer_id'])) {
    header('Location: login.php');
    exit;
}

include '../config/database.php';

$lecturerId = $_SESSION['lecturer_id'];

$date_of_supervision = array_map('htmlspecialchars', $_POST['date_of_supervision']);
$student_name = array_map('htmlspecialchars', $_POST['student_name']);
$index_number = array_map('htmlspecialchars', $_POST['index_number']);
$from_location = array_map('htmlspecialchars', $_POST['from_location']);
$from_location_other = array_map('htmlspecialchars', $_POST['from_location_other']);
$to_location = array_map('htmlspecialchars', $_POST['to_location']);
$to_location_other = array_map('htmlspecialchars', $_POST['to_location_other']);
$distance = array_map('htmlspecialchars', $_POST['distance']);
$nights = array_map('htmlspecialchars', $_POST['nights']);

// Delete existing data
$stmt = $pdo->prepare('DELETE FROM supervision_mapping WHERE lecturer_id = ?');
$stmt->execute([$lecturerId]);

// Insert new data
for ($i = 0; $i < count($date_of_supervision); $i++) {
    $studentName = ($student_name[$i] === 'Other' || empty($student_name[$i])) ? null : $student_name[$i];
    $indexNumber = ($student_name[$i] === 'Other' || empty($student_name[$i])) ? null : $index_number[$i];
    $fromLocation = ($from_location[$i] === 'Other') ? (!empty($from_location_other[$i]) ? $from_location_other[$i] : null) : $from_location[$i];
    $toLocation = ($to_location[$i] === 'Other') ? (!empty($to_location_other[$i]) ? $to_location_other[$i] : null) : $to_location[$i];
    $distanceValue = !empty($distance[$i]) ? $distance[$i] : null;
    $nightValue = !empty($nights[$i]) ? $nights[$i] : null;

    $stmt = $pdo->prepare('INSERT INTO supervision_mapping (lecturer_id, date_of_supervision, student_name, index_number, from_location, to_location, distance, nights) VALUES (?, ?, ?, ?, ?, ?, ?, ?)');
    $stmt->execute([
        $lecturerId,
        $date_of_supervision[$i],
        $studentName,
        $indexNumber,
        $fromLocation,
        $toLocation,
        $distanceValue,
        $nightValue
    ]);
}

header('Location: mapping.php');
exit;
?>
