<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['lecturer_id'])) {
    header('Location: login.php');
    exit;
}

include 'lect_header.php';
include '../config/database.php';

$lecturerId = $_SESSION['lecturer_id'];

// Fetch assigned students' details and their saved results
$stmt = $pdo->prepare('
    SELECT sd.id AS student_id, sd.first_name, sd.surname, u.index_number, sr.marks, sr.grade, sr.gp, sr.description, sr.status
    FROM student_details sd 
    JOIN users u ON sd.user_id = u.id
    LEFT JOIN student_results sr ON sd.id = sr.student_id AND sr.lecturer_id = ?
    WHERE sd.lecturer_id = ?
');
$stmt->execute([$lecturerId, $lecturerId]);
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Check if results have been submitted
$resultsSubmitted = false;
foreach ($students as $student) {
    if ($student['status'] === 'submitted') {
        $resultsSubmitted = true;
        break;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Enter Results</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-4">
        <h2>Enter Results</h2>
        <?php if (empty($students)): ?>
            <div class="alert alert-warning">No students assigned to you yet.</div>
        <?php elseif ($resultsSubmitted): ?>
            <div class="alert alert-info">Results have been submitted and cannot be edited.</div>
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Student Name</th>
                        <th>Index Number</th>
                        <th>Marks</th>
                        <th>Grade</th>
                        <th>GP</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($students as $student): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($student['first_name'] . ' ' . $student['surname']); ?></td>
                            <td><?php echo htmlspecialchars($student['index_number']); ?></td>
                            <td><?php echo htmlspecialchars($student['marks']); ?></td>
                            <td><?php echo htmlspecialchars($student['grade']); ?></td>
                            <td><?php echo htmlspecialchars($student['gp']); ?></td>
                            <td><?php echo htmlspecialchars($student['description']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <form method="POST" action="save_submit_results.php">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Student Name</th>
                            <th>Index Number</th>
                            <th>Marks</th>
                            <th>Grade</th>
                            <th>GP</th>
                            <th>Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($students as $index => $student): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($student['first_name'] . ' ' . $student['surname']); ?></td>
                                <td><?php echo htmlspecialchars($student['index_number']); ?></td>
                                <td><input type="number" name="marks[]" min="0" max="100" class="form-control" value="<?php echo htmlspecialchars($student['marks']); ?>" required oninput="calculateGrade(this.value, <?php echo $index; ?>)"></td>
                                <td id="grade-<?php echo $index; ?>"><?php echo htmlspecialchars($student['grade']); ?></td>
                                <td id="gp-<?php echo $index; ?>"><?php echo htmlspecialchars($student['gp']); ?></td>
                                <td id="description-<?php echo $index; ?>"><?php echo htmlspecialchars($student['description']); ?></td>
                                <input type="hidden" name="student_ids[]" value="<?php echo htmlspecialchars($student['student_id']); ?>">
                                <input type="hidden" name="index_numbers[]" value="<?php echo htmlspecialchars($student['index_number']); ?>">
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <button type="submit" name="action" value="save" class="btn btn-secondary">Save Results</button>
                <button type="submit" name="action" value="submit" class="btn btn-primary">Submit Results</button>
            </form>
        <?php endif; ?>
    </div>
    <?php include 'lect_footer.php'; ?>

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>
    <script>
        function calculateGrade(mark, index) {
            let grade, gp, description;
            if (mark >= 80 && mark <= 100) {
                grade = 'A'; gp = 4.0; description = 'Excellent';
            } else if (mark >= 75 && mark <= 79) {
                grade = 'B+'; gp = 3.5; description = 'Very Good';
            } else if (mark >= 70 && mark <= 74) {
                grade = 'B'; gp = 3.0; description = 'Good';
            } else if (mark >= 65 && mark <= 69) {
                grade = 'C+'; gp = 2.5; description = 'Average';
            } else if (mark >= 60 && mark <= 64) {
                grade = 'C'; gp = 2.0; description = 'Fair';
            } else if (mark >= 55 && mark <= 59) {
                grade = 'D+'; gp = 1.5; description = 'Barely Satisfactory';
            } else if (mark >= 50 && mark <= 54) {
                grade = 'D'; gp = 1.0; description = 'Weak Pass';
            } else if (mark >= 0 && mark <= 49) {
                grade = 'E'; gp = 0.0; description = 'Fail';
            } else {
                grade = ''; gp = ''; description = '';
            }

            document.getElementById('grade-' + index).innerText = grade;
            document.getElementById('gp-' + index).innerText = gp;
            document.getElementById('description-' + index).innerText = description;
        }
    </script>
</body>
</html>
