<?php
session_start();
include '../config/database.php';

if (!isset($_SESSION['reset_user_id']) || !isset($_SESSION['correct_answer'])) {
    echo "<p class='text-danger text-center mt-3'>Invalid session. Please try again.</p>";
    exit;
}

$user_id = $_SESSION['reset_user_id'];
$correct_answer = $_SESSION['correct_answer'];
$success = false;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_answer = (int)$_POST['answer'];
    $new_password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    if ($user_answer !== $correct_answer) {
        $error = "Incorrect multiplication answer. Please try again.";
    } elseif ($new_password !== $confirm_password) {
        $error = "Passwords do not match. Please try again.";
    } else {
        // Hash and update the password
        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare('UPDATE lecturer_login SET password = ? WHERE id = ?');
        $stmt->execute([$hashed_password, $user_id]);

        $success = true;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Reset Password</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="d-flex justify-content-center align-items-center bg-light vh-100">
    <div class="card shadow-lg p-4 rounded-3" style="max-width: 400px; width: 100%;">
        <h2 class="card-title text-center mb-3">Reset Password</h2>
        <?php if (isset($error)): ?>
            <div class="alert alert-danger text-center"><?php echo $error; ?></div>
        <?php endif; ?>

        <?php if (!$success): ?>
            <!-- Password Reset Form -->
            <form method="POST" action="" autocomplete="off">
                <div class="mb-3">
                    <label for="answer" class="form-label fw-bold">Multiply the last two digits of your contact</label>
                    <input type="number" class="form-control" id="answer" name="answer" required placeholder="Enter the result">
                </div>
                <div class="mb-3">
                    <label for="password" class="form-label fw-bold">New Password</label>
                    <input type="password" class="form-control" id="password" name="password" required placeholder="Enter new password">
                </div>
                <div class="mb-3">
                    <label for="confirm_password" class="form-label fw-bold">Confirm New Password</label>
                    <input type="password" class="form-control" id="confirm_password" name="confirm_password" required placeholder="Confirm new password">
                </div>
                <button type="submit" class="btn btn-primary w-100">Reset Password</button>
            </form>
        <?php else: ?>
            <!-- Success Modal Trigger -->
            <script>
                window.onload = function() {
                    let successModal = new bootstrap.Modal(document.getElementById('successModal'));
                    successModal.show();
                };
            </script>
        <?php endif; ?>
    </div>

    <!-- Success Modal -->
    <div class="modal fade" id="successModal" tabindex="-1" aria-labelledby="successModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="successModalLabel">Password Reset Successful</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center">
                    <p>Your password has been reset successfully!</p>
                </div>
                <div class="modal-footer">
                    <a href="login.php" class="btn btn-primary w-100">Go to Login</a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
