<?php
session_start();
if (!isset($_SESSION['lecturer_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

include '../config/database.php';

$input = json_decode(file_get_contents('php://input'), true);
if (isset($input['id'])) {
    $supervisionId = $input['id'];

    try {
        // Prepare and execute the delete statement
        $stmt = $pdo->prepare('DELETE FROM supervision_mapping WHERE id = ? AND lecturer_id = ?');
        $stmt->execute([$supervisionId, $_SESSION['lecturer_id']]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Record not found or unauthorized']);
        }
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid input']);
}
?>
