<?php
// Existing functions in the project

function registerUser($pdo, $indexNumber, $password, $group, $securityQuestion, $securityAnswer, $academicYear = null) {
    // Sanitize input using htmlspecialchars
    $indexNumber = htmlspecialchars($indexNumber, ENT_QUOTES, 'UTF-8');
    $group = htmlspecialchars($group, ENT_QUOTES, 'UTF-8');
    $securityQuestion = htmlspecialchars($securityQuestion, ENT_QUOTES, 'UTF-8');
    $securityAnswer = htmlspecialchars($securityAnswer, ENT_QUOTES, 'UTF-8');
    $academicYear = $academicYear ? htmlspecialchars($academicYear, ENT_QUOTES, 'UTF-8') : null;

    // Check if the user exists
    $stmt = $pdo->prepare('SELECT * FROM users WHERE index_number = ?');
    $stmt->execute([$indexNumber]);
    $user = $stmt->fetch();

    if ($user) {
        // User already exists, return an error
        return false;
    } else {
        // Insert a new user with sanitized input and hashed password
        $stmt = $pdo->prepare('INSERT INTO users (index_number, password, `group`, security_question, security_answer, academic_year) VALUES (?, ?, ?, ?, ?, ?)');
        $stmt->execute([$indexNumber, password_hash($password, PASSWORD_DEFAULT), $group, $securityQuestion, $securityAnswer, $academicYear]);
        return true;
    }
}

function getUser($pdo, $indexNumber) {
    // Sanitize input using htmlspecialchars
    $indexNumber = htmlspecialchars($indexNumber, ENT_QUOTES, 'UTF-8');

    $stmt = $pdo->prepare('SELECT * FROM users WHERE index_number = ?');
    $stmt->execute([$indexNumber]);
    return $stmt->fetch();
}

// New log_action function to be added for audit logging
function log_action($user_id, $username, $action, $affected_table = null, $affected_id = null, $old_values = null, $new_values = null) {
    global $pdo;

    // Capture IP Address and User Agent
    $ip_address = $_SERVER['REMOTE_ADDR'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'];

    // Capture changes as a JSON string
    $changes = json_encode(['old' => $old_values, 'new' => $new_values]);

    // Generate a signature using HMAC with a secret key (replace 'secret_key' with a more secure key)
    $signature_data = "$user_id|$username|$action|$affected_table|$affected_id|$ip_address|$user_agent|$changes";
    $secret_key = 'my_secret_key'; // Replace with your secure secret key
    $signature = hash_hmac('sha256', $signature_data, $secret_key);

    // Create a hash of the entire log entry for integrity verification
    $hash = hash('sha256', $signature_data);

    // Prepare and execute the SQL query to insert into audit_log table
    $stmt = $pdo->prepare('INSERT INTO audit_log (user_id, username, action, affected_table, affected_id, ip_address, user_agent, changes, signature, hash) 
                           VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)');
    $stmt->execute([$user_id, $username, $action, $affected_table, $affected_id, $ip_address, $user_agent, $changes, $signature, $hash]);
}
?>
