# Student Module — Summary & How to Start the New Project

Use this with **docs/PROJECT_OVERVIEW.md** when starting the new IMS. Phase 1 is **students only**.

---

## 1. What the Student Part Does (Legacy Reference)

### 1.1 Student journey (high level)

1. **Register** — Index number, password, group (Industrial Internship / Teaching Practice), security question/answer. Registration can be gated by academic year and start/end dates (settings).
2. **Login / Logout** — Session-based; student lands on dashboard.
3. **Dashboard** — Shows submission status (saved vs submitted), next steps, assigned lecturer name (once assigned). Links to: student details, transfer request, submit letter, internship report, teaching report, view submission, download evaluation, group info, change password.
4. **Student details (placement)** — Form: surname, first name, other names, telephone, email, course (depends on group), organisation name, months, location, GPS, region, district, acceptance letter (PDF/images). **Save** = draft; **Submit** = final (feeds admin/lecturer). Districts loaded by region (e.g. from `districts` table).
5. **Transfer request** — Request new placement: new organisation, location, GPS, region, district, reason, optional acceptance letter. Status: pending → approved/rejected (admin/lecturer). Student sees status on transfer status page.
6. **Submit letter** — Submit internship acceptance letter (separate flow if needed); view submission; download own submission.
7. **Internship report** — Form for post-internship report (company from student_details); save draft / submit. Desktop-only in legacy (optional in new).
8. **Teaching report** — Similar flow for teaching practice reports.
9. **Download evaluation** — Download evaluation document (e.g. PDF) for the student.
10. **Account** — Change password; forgot password (security question); reset password.
11. **Other** — Group info page; photo uploads (e.g. photo album); unread count and mark as read (simple notifications).

### 1.2 Data the student touches (conceptual)

- **users** — index_number, password, group, security question/answer (and auth).
- **student_details** — name, contact, course, organisation, duration, location, GPS, region, district, acceptance_letter, status (saved/submitted), lecturer_id (assigned later).
- **districts** — region, district (read-only for student).
- **transfer_requests** — new placement fields, reason, acceptance_letter, status (pending/approved/rejected).
- **internship_reports** / teaching reports — report content, status (saved/submitted).
- **Submissions / evaluations** — letter uploads, view, download; evaluation download.
- **Settings** (optional) — e.g. current_academic_year, registration_start_date_*, registration_end_date_*, registration_status_*.

---

## 2. How to Start the New Project (Phase 1)

### Step 1: New codebase and repo

- Create a **new project folder/repo** for the new IMS (do not mix with legacy `ims_old`).
- Use **docs/PROJECT_OVERVIEW.md** and this doc as the source of truth.

### Step 2: Choose stack (and stick to it)

- **Backend:** e.g. Laravel (PHP), Node (Express/Fastify), or similar. Expose **REST (or GraphQL) APIs** for all student actions. Design APIs so lecturer/admin can reuse them later.
- **Frontend:** e.g. React, Vue, Svelte, or Next/Nuxt. Or server-rendered (e.g. Laravel Blade, Next). One clear place for student UI.
- **Database:** MySQL or PostgreSQL; migrations from day one; env-based config (no credentials in repo).
- **Auth:** Session or JWT; secure password reset (token + expiry). If you keep “security question” for forgot password, store and validate it safely.

### Step 3: Implement in this order

| Order | What to build | Notes |
|-------|----------------|-------|
| 1 | Project setup, DB, env, migrations | Schema for users, student_details, districts, transfer_requests, reports, etc. |
| 2 | Auth: register, login, logout | Include group; optional: registration window (settings or config). |
| 3 | Dashboard (post-login home) | Status (saved/submitted), next steps; lecturer name when available. |
| 4 | Student details form | Save draft + submit; region → districts; acceptance letter upload (validate type/size). |
| 5 | Transfer request + transfer status | Create request; list/status (pending/approved/rejected). |
| 6 | Submit letter, view submission, download submission | APIs + UI. |
| 7 | Internship report + teaching report | Save draft + submit; optional desktop-only or responsive. |
| 8 | Download evaluation | API + UI to download file. |
| 9 | Change password; forgot/reset password | Secure flow; optional security question. |
| 10 | Group info, photo uploads, notifications | Can stub (e.g. “Coming soon”) if time is short. |

### Step 4: What *not* to build in Phase 1

- No lecturer UI or admin UI or system-admin UI.
- No help site (or only a static/minimal page).
- Build only **student-facing** features; backend APIs and schema should be ready for lecturer/admin later.

### Step 5: Prompt to give Cursor when starting

You can say (or paste):

- *“We are building Phase 1 of the new IMS: **student module only**. Read **docs/PROJECT_OVERVIEW.md** and **docs/STUDENT_MODULE_AND_START.md**. Set up the new project (backend + frontend + DB migrations), then implement in this order: (1) project setup and schema, (2) register/login/logout, (3) dashboard, (4) student details form with save/submit and acceptance letter, (5) transfer request and status, (6) submit letter and view/download submission, (7) internship and teaching reports, (8) download evaluation, (9) change password and forgot/reset password. Do not build lecturer or admin UI. Design APIs so they can be reused in later phases.”*

---

## 3. One-Paragraph Recap

The **student part** lets students register (index number, group, security Q&A), log in, and use a dashboard. They submit **placement details** (name, contact, course, organisation, region/district, acceptance letter) with save draft or submit. They can **request a transfer** (new placement + reason) and check **transfer status**. They **submit letters**, **internship/teaching reports**, **view/download submission**, and **download evaluation**. They can **change password** and use **forgot/reset password**. Optional: group info, photo uploads, simple notifications. To **start the new project**, create a new repo, choose a modern stack (API + frontend + DB), implement in the order above, and use the two docs plus the prompt so Cursor builds Phase 1 (students only) correctly.
