# SOB-IMS — Project Overview

This document is the **single source of truth** for the Internship Management System (IMS) project. Use it to onboard Cursor, the team, and any new developers **before** starting work (e.g. before building the new student-facing version).

---

## 1. What This Project Is

**SOB-IMS** (School of Business – Internship Management System) is a web application for managing **student internships** for a business school (or similar institution). It supports:

- **Industrial Internship** — students placed in organisations (companies, institutions) by **region** and **district**.
- **Teaching Practice** — students placed in schools; same placement model (region/district).

The system covers the full lifecycle: **registration → placement (district/region) → optional transfers → supervision (lecturer assignment, routes) → post-internship reports and evaluations**.

---

## 2. Users (Actors)

| Actor | Purpose |
|-------|--------|
| **Student** | Registers, submits placement details and acceptance letter, requests transfers, submits internship/teaching reports, views status and assigned lecturer. |
| **Lecturer** | Gets assigned districts/regions; manages student mapping; grades reports; handles preferences; exports Excel/PDF; sends SMS. |
| **Admin** | Assigns students to districts, assigns lecturers to districts, approves/rejects transfers, manages lecturers, views students, route allocation, results, post-internship reports, uploads (e.g. index numbers). |
| **System Admin** | Manages admin accounts, cleans/verifies data, audit log, submissions without letters, resets. |

---

## 3. Domain Concepts (Glossary)

- **Group** — Student cohort type: e.g. *Industrial Internship*, *Teaching Practice*. Determines available courses and flows.
- **Region / District** — Geographic placement. Students choose/are assigned a **district** (within a **region**). Lecturers are assigned to districts for supervision.
- **Placement / Mapping** — Linking students and lecturers to districts/regions. “Mapping” often refers to the lecturer–district assignment and the resulting student–lecturer assignment.
- **Transfer** — Student request to change district/placement; admin (or lecturer) approves or rejects.
- **Acceptance letter** — Document (e.g. PDF/image) from the host organisation confirming internship placement.
- **Submission status** — Student details can be *saved* (draft) or *submitted* (final). Once submitted, they feed into admin/lecturer workflows.
- **Post-internship (PI)** — Phase after placement: reports, teaching reports, evaluations, grades. “PI” appears in reports and results.
- **Supervision / Route** — Lecturers supervise students in assigned districts; “route allocation” refers to organising supervision by region/district (e.g. for visits).

---

## 4. Current System (Legacy) — Summary

- **Stack:** PHP (procedural), single entry point `index.php` with path-based routing (`/ims/`), MySQL (DB: `internship_portal`), Composer packages (PhpSpreadsheet, FPDF/FPDI, PHPWord, Dompdf, TCPDF, pdfparser).
- **Structure:** Separate areas: `student/`, `lecturer/`, `admin/`, `sys_admin/`, `help/`, `includes/`, `config/`, `errors/`. Session-based auth (`user_id`, `admin_id`, `sys_admin_id`, `role`).
- **Student flows:** Registration, login, dashboard, student details form (region/district, acceptance letter upload), transfer request/status, submit letter, internship report, teaching report, view/download submission, download evaluation, change/forgot/reset password, group info, photo uploads, basic “mark as read” / unread count.

This overview does **not** require implementing the legacy code as-is; it describes **what the system does** so the new version can replicate and improve on it.

---

## 5. New Version — Direction and Scope

We are building a **new version** of IMS (new codebase, modern stack). The overview below defines scope and order of work.

### 5.1 Phased Rollout

| Phase | Scope | Notes |
|-------|--------|------|
| **Phase 1** | **Student module only** | All student-facing features; no admin/lecturer/sys_admin UI. APIs and data model should allow adding other roles later. |
| Phase 2 | Lecturer module | District/region assignment, mapping, grading, exports, SMS, etc. |
| Phase 3 | Admin module | Assignments, transfers, route allocation, results, reports, uploads. |
| Phase 4 | System admin + help | Admin management, data tools, audit, help content/support. |

**Current decision:** Proceed with **Phase 1 (Student module)** only. Do not build lecturer/admin/sys_admin UI in Phase 1; only design APIs and schemas with them in mind.

### 5.2 Student Module (Phase 1) — In Scope

- **Auth:** Registration (e.g. index number/credentials), login, logout, change password, forgot password, reset password.
- **Profile / placement:** Student details form: name (surname, first, other), contact (telephone, email), course, organisation name, duration (months), location, GPS, region, district, acceptance letter (file upload). Save as draft + submit.
- **Placement UX:** Student in a “group” (e.g. Industrial Internship / Teaching Practice); courses list depends on group; districts loaded by region.
- **Transfers:** Request transfer (e.g. change district), view transfer status.
- **Submissions & reports:** Submit letter; internship report; teaching report; view submission; download own submission; download evaluation.
- **Dashboard:** Post-login home with status (e.g. submitted/saved), next steps, and assigned lecturer name when applicable.
- **Other:** Group info, photo uploads (e.g. photo album), simple notifications (e.g. unread count, mark as read) — can be stubbed or simplified in Phase 1.

### 5.3 Out of Scope for Phase 1

- Lecturer-facing screens and flows.
- Admin-facing screens and flows.
- System-admin screens and flows.
- Help site can be a static or minimal copy; full help/support can be Phase 4.

---

## 6. Technical Expectations for the New Version

- **Clear separation:** Prefer a defined backend (API) and frontend (e.g. SPA or server-rendered app). If staying PHP, use a modern framework and structure.
- **Database:** Relational DB (e.g. PostgreSQL or MySQL); normalized schema, migrations, no credentials in repo (use env).
- **Security:** Validation (backend + optional frontend), CSRF protection, safe file uploads (type/size), parameterized queries, no secrets in code.
- **APIs:** Design so lecturer and admin clients can reuse the same APIs in later phases.

---

## 7. How to Use This Document

- **Before starting Phase 1 (student side):** Ensure Cursor and the team have read this overview. Use it in the prompt or in the repo so that “build the student module” is unambiguous.
- **When starting Phase 1:** Reference this doc and add a Phase-1-specific prompt or spec (e.g. tech stack, folder structure, first user stories) that builds on sections 5.2 and 6.
- **Later phases:** Extend this overview with lecturer/admin/sys_admin sections or link to separate module specs.

---

## 8. One-Sentence Summary

**SOB-IMS is an internship management system for a business school: students submit placements and reports and request transfers; lecturers and admins manage district/region mapping, supervision, and approvals; the new version will be built in phases, starting with the student module only.**
