<?php
// db_gateway.php
header('Content-Type: application/json');

// Database credentials (update with your real values)
$host = 'localhost';
$db   = 'internship_portal';
$user = 'sob_admin';
$pass = '4f3z8g7S@';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);

    // List all tables
    if (isset($_GET['action']) && $_GET['action'] === 'list_tables') {
        $stmt = $pdo->query("SHOW TABLES");
        $tables = $stmt->fetchAll(PDO::FETCH_NUM);
        $tableNames = array_map(function($row) { return $row[0]; }, $tables);
        echo json_encode(['tables' => $tableNames]);
        exit;
    }

    // Fetch rows from a specific table
    if (isset($_GET['action']) && $_GET['action'] === 'fetch_table' && isset($_GET['table'])) {
        $stmt = $pdo->query("SHOW TABLES");
        $tables = $stmt->fetchAll(PDO::FETCH_COLUMN, 0);
        $requestedTable = $_GET['table'];
        if (!in_array($requestedTable, $tables)) {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid table name']);
            exit;
        }
        $stmt = $pdo->query("SELECT * FROM `$requestedTable` LIMIT 100");
        $rows = $stmt->fetchAll();
        echo json_encode(['rows' => $rows]);
        exit;
    }

    // Custom: Internship report list with correct name mapping, all reports, ordered by submission_date
    if (isset($_GET['action']) && $_GET['action'] === 'internship_report_list') {
        $sql = "SELECT 
                    sd.surname, sd.first_name, sd.other_names, 
                    ir.department, ir.company, ir.id, ir.user_id, ir.submission_date
                FROM internship_reports ir
                JOIN student_details sd ON ir.user_id = sd.user_id
                JOIN users u ON sd.user_id = u.id
                WHERE sd.status = 'submitted'
                ORDER BY ir.submission_date DESC";
        $stmt = $pdo->query($sql);
        $rows = $stmt->fetchAll();
        echo json_encode(['rows' => $rows]);
        exit;
    }

    // Default: Only allow a safe, fixed query for demonstration
    $stmt = $pdo->query("SELECT id FROM users LIMIT 10");
    $users = $stmt->fetchAll();
    echo json_encode(['users' => $users]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
} 