<?php
// Check if a theme preference exists via cookie; default to light if not set.
$theme = isset($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Dashboard</title>

  <!-- Bootstrap 5.3 CSS -->
  <link 
    href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" 
    rel="stylesheet"
  >

  <!-- Font Awesome CSS (for icons) -->
  <link 
    rel="stylesheet" 
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css"
  >

  <style>
    body {
      font-family: 'Inter', sans-serif;
      transition: background 0.3s, color 0.3s;
    }
    /* Dark Mode */
    .dark-mode {
      background-color: #1a202c;
      color: white;
    }
    /* Light Mode */
    .light-mode {
      background-color: #ffffff;
      color: black;
    }
    /* Remove default dropdown caret from Bootstrap */
    .dropdown-toggle::after {
      display: none;
    }
    /* Override blue active/focus color for dropdown items */
    .dropdown-item:focus,
    .dropdown-item:active {
      background-color: transparent;
      color: inherit;
      outline: none;
      box-shadow: none;
    }
    /* Buttons */
    .btn-custom {
      padding: 10px 20px;
      border-radius: 6px;
      font-weight: bold;
      transition: all 0.3s ease-in-out;
      display: inline-block;
      text-align: center;
    }
    /* Dark Mode Button Colors */
    .dark-mode .btn-custom {
      background-color: #4a5568;
      color: white;
    }
    .dark-mode .btn-custom:hover {
      background-color: #2d3748;
    }
    /* Light Mode Button Colors */
    .light-mode .btn-custom {
      background-color: #1f2a38;
      color: white;
    }
    .light-mode .btn-custom:hover {
      background-color: #16202d;
    }
    /* Card Styles */
    .card-custom {
      padding: 20px;
      border-radius: 10px;
      transition: all 0.3s ease-in-out;
      height: 100%;
      display: flex;
      flex-direction: column;
    }
    
    .card-custom .card-title {
      margin-bottom: 0.75rem;
    }
    
    .card-custom .card-text {
      flex-grow: 1;
      margin-bottom: 1rem;
    }
    
    .card-custom .btn {
      margin-top: auto;
    }
    /* Dark Mode Cards */
    .dark-mode .card-custom {
      background-color: #2d3748;
      color: white;
    }
    /* Light Mode Cards */
    .light-mode .card-custom {
      background-color: #f7f9fa;
      color: black;
    }
    /* +++++ NEW CODE: Modal Dark Mode Overrides +++++ */
    .dark-mode .modal-content {
      background-color: #2d3748;
      color: #fff;
    }
    .dark-mode .modal-header,
    .dark-mode .modal-body,
    .dark-mode .modal-footer {
      background-color: #2d3748;
      color: #fff;
    }
  </style>
</head>

<!-- Apply light-mode or dark-mode class to the body -->
<body class="<?php echo $theme; ?>-mode">

  <!-- Navbar -->
  <nav class="navbar navbar-expand-lg navbar-dark" style="background-color: #1f2a38;">
    <div class="container-fluid">
      <a class="navbar-brand" href="#">SOB Post-Internship</a>
      <div class="d-flex align-items-center">

        <!-- Dashboard Link -->
        <a href="pi" class="btn btn-outline-light me-2">Dashboard</a>

        <!-- Reports Link -->
        <a href="post_internship_reports" class="btn btn-outline-light me-2">Reports</a>

        <!-- Dropdown for Theme Switcher and Logout -->
        <div class="dropdown">
          <a 
            class="nav-link dropdown-toggle text-light" 
            href="#" 
            id="themeDropdown" 
            data-bs-toggle="dropdown" 
            aria-expanded="false"
          >
            <i class="fa fa-caret-down"></i>
          </a>
          <ul 
            class="dropdown-menu dropdown-menu-end" 
            aria-labelledby="themeDropdown"
          >
            <li>
              <a class="dropdown-item" href="#" id="themeToggle">
                <?php 
                  if($theme == 'light') {
                    echo '<i class="fa fa-moon"></i> Switch to Dark Theme';
                  } else {
                    echo '<i class="fa fa-sun"></i> Switch to Light Theme';
                  }
                ?>
              </a>
            </li>
            <li><hr class="dropdown-divider"></li>
            <li>
              <a class="dropdown-item" href="logout">
                <i class="fa fa-sign-out-alt"></i> Logout
              </a>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </nav>
