<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

include '../config/database.php';

// Get the lecturer ID from the URL
if (isset($_GET['lecturer_id'])) {
    $lecturerId = intval($_GET['lecturer_id']);
    
    // Update lecturer_login to grant edit permission
    $stmt = $pdo->prepare('UPDATE lecturer_login SET mapping_submitted = 0 WHERE id = ?');
    $stmt->execute([$lecturerId]);

    // Update supervision_mapping to change status to "Saved" for all records associated with the lecturer
    $stmt = $pdo->prepare('UPDATE supervision_mapping SET status = "Saved" WHERE lecturer_id = ? AND status = "Submitted"');
    $stmt->execute([$lecturerId]);
    
    // Redirect back to the mapping page
    header('Location: mapping.php');
    exit;
} else {
    echo "No lecturer ID provided.";
}
?>