<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['admin_id'])) {
    echo json_encode([]);
    exit;
}

require '../config/database.php';

$lecturerId = $_GET['lecturer_id'] ?? null;
$region = $_GET['region'] ?? null;

if (!$lecturerId || !$region) {
    echo json_encode([]);
    exit;
}

$stmt = $pdo->prepare('
    SELECT district
    FROM lecturer_assigned_districts
    WHERE lecturer_id = :lecturer_id AND region = :region
    ORDER BY district
');
$stmt->execute([
    ':lecturer_id' => $lecturerId,
    ':region' => $region
]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($rows);
exit;
