<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}

include '../config/database.php';

// Fetch all distinct regions from lecturer preferences
$stmt = $pdo->prepare('SELECT DISTINCT preferred_region FROM lecturer_preferences ORDER BY preferred_region');
$stmt->execute();
$regions = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Initialize an empty array for lecturers
$lecturers = [];

if (isset($_GET['region']) && !empty($_GET['region'])) {
    $selectedRegion = htmlspecialchars($_GET['region'], ENT_QUOTES, 'UTF-8');

    // Fetch lecturers who have selected the chosen region
    $stmt = $pdo->prepare('
        SELECT ll.id AS lecturer_id, ll.name, ll.department, lp.preferred_region, lp.preferred_districts
        FROM lecturer_login ll
        JOIN lecturer_preferences lp ON ll.id = lp.lecturer_id
        WHERE lp.preferred_region = ?
    ');
    $stmt->execute([$selectedRegion]);
    $lecturers = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Assign Districts</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>

<?php include 'admin_header.php'; ?>

<div class="container mt-4">
    <h2>Assign Districts</h2>
    
    <!-- Region Selection Dropdown -->
    <form method="GET" action="assign_district.php">
        <div class="mb-3">
            <label for="region" class="form-label">Select Region:</label>
            <select name="region" id="region" class="form-select" onchange="this.form.submit()">
                <option value="">Select Region</option>
                <?php foreach ($regions as $region): ?>
                    <option value="<?php echo htmlspecialchars($region['preferred_region'], ENT_QUOTES, 'UTF-8'); ?>" <?php echo (isset($selectedRegion) && $selectedRegion === $region['preferred_region']) ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($region['preferred_region'], ENT_QUOTES, 'UTF-8'); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    </form>

    <?php if (!empty($lecturers)): ?>
        <div class="row">
            <?php foreach ($lecturers as $lecturer): ?>
                <div class="col-md-4 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title"><?php echo htmlspecialchars($lecturer['name'], ENT_QUOTES, 'UTF-8'); ?></h5>
                            <p class="card-text"><strong>Department:</strong> <?php echo htmlspecialchars($lecturer['department'], ENT_QUOTES, 'UTF-8'); ?></p>
                            <p class="card-text"><strong>Preferred Region:</strong> <?php echo htmlspecialchars($lecturer['preferred_region'], ENT_QUOTES, 'UTF-8'); ?></p>
                            <p class="card-text"><strong>Assigned Districts:</strong> 
                                <?php echo htmlspecialchars($lecturer['preferred_districts'] ?: 'None', ENT_QUOTES, 'UTF-8'); ?>
                            </p>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <?php if (isset($selectedRegion)): ?>
            <p>No lecturers have selected this region.</p>
        <?php endif; ?>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>
</body>
</html>
