<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}
include '../config/database.php';

$studentId = isset($_GET['id']) ? intval($_GET['id']) : 0;

$stmt = $pdo->prepare('SELECT * FROM student_details WHERE id = ?');
$stmt->execute([$studentId]);
$student = $stmt->fetch(PDO::FETCH_ASSOC);

if ($student):
?>
    <h5>Student Details</h5>
    <p><strong>Surname:</strong> <?php echo htmlspecialchars($student['surname'], ENT_QUOTES, 'UTF-8'); ?></p>
    <p><strong>First Name:</strong> <?php echo htmlspecialchars($student['first_name'], ENT_QUOTES, 'UTF-8'); ?></p>
    <p><strong>Other Names:</strong> <?php echo htmlspecialchars($student['other_names'], ENT_QUOTES, 'UTF-8'); ?></p>
    <p><strong>Telephone:</strong> <?php echo htmlspecialchars($student['telephone'], ENT_QUOTES, 'UTF-8'); ?></p>
    <p><strong>Email:</strong> <?php echo htmlspecialchars($student['email'], ENT_QUOTES, 'UTF-8'); ?></p>
    <p><strong>Course:</strong> <?php echo htmlspecialchars($student['course'], ENT_QUOTES, 'UTF-8'); ?></p>
    <p><strong>Organisation:</strong> <?php echo htmlspecialchars($student['organisation_name'], ENT_QUOTES, 'UTF-8'); ?></p>
    <p><strong>Months:</strong> <?php echo htmlspecialchars($student['months'], ENT_QUOTES, 'UTF-8'); ?></p>
    <p><strong>Location:</strong> <?php echo htmlspecialchars($student['location'], ENT_QUOTES, 'UTF-8'); ?></p>
    <p><strong>GPS Location:</strong> <?php echo htmlspecialchars($student['gps_location'], ENT_QUOTES, 'UTF-8'); ?></p>
    <p><strong>Region:</strong> <?php echo htmlspecialchars($student['region'], ENT_QUOTES, 'UTF-8'); ?></p>
    <p><strong>District:</strong> <?php echo htmlspecialchars($student['district'], ENT_QUOTES, 'UTF-8'); ?></p>
    <?php if ($student['acceptance_letter']): ?>
        <p><strong>Acceptance Letter:</strong> <a href="../uploads/<?php echo htmlspecialchars($student['acceptance_letter'], ENT_QUOTES, 'UTF-8'); ?>" target="_blank">View</a></p>
    <?php endif; ?>
<?php
else:
?>
    <p>Student not found.</p>
<?php
endif;
?>
