<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

include '../config/database.php';

if (isset($_POST['lecturer_id'])) {
    // Sanitize and validate the lecturer_id input
    $lecturerId = htmlspecialchars($_POST['lecturer_id'], ENT_QUOTES, 'UTF-8');

    if (is_numeric($lecturerId)) {
        // Grant permission to the lecturer
        $stmt = $pdo->prepare('INSERT INTO lecturer_permissions (lecturer_id) VALUES (?)');
        $stmt->execute([$lecturerId]);

        // Allow the lecturer to edit the mapping again
        $stmt = $pdo->prepare('UPDATE lecturer_login SET mapping_edit_permission = 1 WHERE id = ?');
        $stmt->execute([$lecturerId]);
    } else {
        // Handle invalid lecturer_id
        http_response_code(400);
        echo "Invalid lecturer ID";
        exit;
    }
}

// Redirect back to the submissions page
header('Location: sub_map.php');
exit;
?>
