<?php
include '../config/database.php';

$lecturerId = htmlspecialchars($_GET['lecturer_id'], ENT_QUOTES, 'UTF-8');
$region = htmlspecialchars($_GET['region'], ENT_QUOTES, 'UTF-8');

$stmt = $pdo->prepare('SELECT district FROM lecturer_assigned_districts WHERE lecturer_id = ? AND region = ?');
$stmt->execute([$lecturerId, $region]);
$assignedDistricts = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode(array_map(function($district) {
    return array_map('htmlspecialchars', $district);
}, $assignedDistricts));
