<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}
include '../includes/admin_header.php';
include '../config/database.php';

$lecturerId = isset($_GET['lecturer_id']) ? htmlspecialchars($_GET['lecturer_id'], ENT_QUOTES, 'UTF-8') : null;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $students = array_map('htmlspecialchars', $_POST['students']);
    $lecturerId = htmlspecialchars($_POST['lecturer_id'], ENT_QUOTES, 'UTF-8');

    // Fetch lecturer preferences
    $stmt = $pdo->prepare('SELECT preferred_region, preferred_districts FROM lecturer_preferences WHERE lecturer_id = ?');
    $stmt->execute([$lecturerId]);
    $preferences = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($preferences) {
        $preferredRegion = htmlspecialchars($preferences['preferred_region'], ENT_QUOTES, 'UTF-8');
        $preferredDistricts = explode(',', $preferences['preferred_districts']);
        $preferredDistricts = array_map(function($district) {
            return htmlspecialchars($district, ENT_QUOTES, 'UTF-8');
        }, $preferredDistricts);

        // Assign students to the lecturer only if they match the lecturer's preferences
        foreach ($students as $studentId) {
            // Fetch student details
            $stmt = $pdo->prepare('SELECT region, district FROM student_details WHERE id = ?');
            $stmt->execute([$studentId]);
            $student = $stmt->fetch(PDO::FETCH_ASSOC);

            // Check if student matches lecturer's preferences
            if ($student && $preferredRegion == htmlspecialchars($student['region'], ENT_QUOTES, 'UTF-8') && in_array(htmlspecialchars($student['district'], ENT_QUOTES, 'UTF-8'), $preferredDistricts)) {
                // Assign student to lecturer
                $stmt = $pdo->prepare('INSERT INTO lecturer_student_assignments (lecturer_id, student_id) VALUES (?, ?)');
                $stmt->execute([$lecturerId, $studentId]);
            }
        }
    }
    header('Location: view_lecturers.php');
    exit;
}

// Fetch lecturer details
$stmt = $pdo->prepare('SELECT name FROM lecturer_login WHERE id = ?');
$stmt->execute([$lecturerId]);
$lecturer = $stmt->fetch(PDO::FETCH_ASSOC);

// Fetch students without a lecturer whose region and district match the lecturer's preferences
$stmt = $pdo->prepare('
    SELECT s.id, s.surname, s.first_name
    FROM student_details s
    JOIN lecturer_preferences lp ON s.region = lp.preferred_region AND FIND_IN_SET(s.district, lp.preferred_districts)
    WHERE s.id NOT IN (SELECT student_id FROM lecturer_student_assignments) AND lp.lecturer_id = ?
');
$stmt->execute([$lecturerId]);
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-4">
    <h2>Assign Students to <?php echo htmlspecialchars($lecturer['name'], ENT_QUOTES, 'UTF-8'); ?></h2>
    <form method="POST" action="assign_students.php">
        <input type="hidden" name="lecturer_id" value="<?php echo htmlspecialchars($lecturerId, ENT_QUOTES, 'UTF-8'); ?>">
        <div class="mb-3">
            <label for="students" class="form-label">Select Students</label>
            <select class="form-control" id="students" name="students[]" multiple required>
                <?php foreach ($students as $student): ?>
                    <option value="<?php echo htmlspecialchars($student['id'], ENT_QUOTES, 'UTF-8'); ?>">
                        <?php echo htmlspecialchars($student['surname'] . ' ' . $student['first_name'], ENT_QUOTES, 'UTF-8'); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <button type="submit" class="btn btn-primary">Assign Students</button>
    </form>
</div>

<?php include '../../includes/footer.php'; ?>
