<?php
include '../includes/header.php';
$statusMessage = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    include '../config/database.php';
    $token = htmlspecialchars($_POST['token'], ENT_QUOTES, 'UTF-8');
    $newPassword = $_POST['newPassword'];
    $confirmPassword = $_POST['confirmPassword'];

    if ($newPassword !== $confirmPassword) {
        $statusMessage = 'Passwords do not match.';
    } else {
        $stmt = $pdo->prepare('SELECT user_id FROM password_resets WHERE token = ?');
        $stmt->execute([$token]);
        $resetRequest = $stmt->fetch();

        if ($resetRequest) {
            $newPasswordHash = password_hash($newPassword, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare('UPDATE users SET password = ? WHERE id = ?');
            $stmt->execute([$newPasswordHash, $resetRequest['user_id']]);

            $stmt = $pdo->prepare('DELETE FROM password_resets WHERE token = ?');
            $stmt->execute([$token]);

            $statusMessage = 'Password has been reset successfully. Redirecting to login...';
            header("refresh:5;url=/login");

        } else {
            $statusMessage = 'Invalid or expired token.';
        }
    }
} else {
    $token = htmlspecialchars($_GET['token'] ?? '', ENT_QUOTES, 'UTF-8');
}
?>

<div class="container d-flex justify-content-center align-items-center" style="min-height: 100vh;">
    <div class="card p-4" style="width: 100%; max-width: 400px;">
        <h2 class="card-title text-center">Reset Password</h2>
        <?php if ($statusMessage): ?>
            <div class="alert alert-info"><?php echo htmlspecialchars($statusMessage, ENT_QUOTES, 'UTF-8'); ?></div>
        <?php endif; ?>
        <form method="POST" action="reset_password.php">
            <input type="hidden" name="token" value="<?php echo htmlspecialchars($token, ENT_QUOTES, 'UTF-8'); ?>">
            <div class="mb-3">
                <label for="newPassword" class="form-label">New Password</label>
                <input type="password" class="form-control" id="newPassword" name="newPassword" required>
            </div>
            <div class="mb-3">
                <label for="confirmPassword" class="form-label">Confirm New Password</label>
                <input type="password" class="form-control" id="confirmPassword" name="confirmPassword" required>
            </div>
            <button type="submit" class="btn btn-primary w-100">Reset Password</button>
        </form>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
