<?php
include '../config/database.php';
include '../includes/functions.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize and escape the input fields
    $indexNumber = htmlspecialchars(trim($_POST['indexNumber']), ENT_QUOTES, 'UTF-8');
    $password = htmlspecialchars(trim($_POST['password']), ENT_QUOTES, 'UTF-8');
    $confirmPassword = htmlspecialchars(trim($_POST['confirmPassword']), ENT_QUOTES, 'UTF-8');
    $group = htmlspecialchars(trim($_POST['group']), ENT_QUOTES, 'UTF-8');
    $securityQuestion = htmlspecialchars(trim($_POST['securityQuestion']), ENT_QUOTES, 'UTF-8');
    $securityAnswer = htmlspecialchars(trim($_POST['securityAnswer']), ENT_QUOTES, 'UTF-8');

    if ($password !== $confirmPassword) {
        header('Location: register.php?error=password_mismatch');
        exit;
    }

    // Check if the index number is in the valid_index_numbers table
    $stmt = $pdo->prepare('SELECT * FROM valid_index_numbers WHERE index_number = ?');
    $stmt->execute([$indexNumber]);
    $validIndex = $stmt->fetch();

    if ($validIndex) {
        // Register the user
        if (registerUser($pdo, $indexNumber, $password, $group, $securityQuestion, $securityAnswer)) {
            // Log the registration action
            log_action(
                null, // No user ID since it's a new registration
                $indexNumber, // Use the new index number as the username
                "User Registered: $indexNumber", // Log message
                'users', // Affected table
                null, // No specific row ID
                null, // Old values (none since it's a new registration)
                ['index_number' => $indexNumber, 'group' => $group, 'security_question' => $securityQuestion] // New values
            );

            header('Location: login.php');
        } else {
            header('Location: register.php?error=index_exists');
        }
    } else {
        header('Location: register.php?error=index_not_found');
    }
}
?>
