<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

require '../vendor/fpdf/fpdf.php';
include '../config/database.php';

// Fetch the logged-in student's submission details
$userId = $_SESSION['user_id'];
$indexNumber = htmlspecialchars($_SESSION['index_number'], ENT_QUOTES, 'UTF-8');
$stmt = $pdo->prepare('SELECT * FROM student_details WHERE user_id = ?');
$stmt->execute([$userId]);
$studentDetails = $stmt->fetch();

if (!$studentDetails) {
    echo "No submission found.";
    exit;
}

// Create the PDF
class PDF extends FPDF
{
    private $indexNumber;

    function __construct($indexNumber)
    {
        parent::__construct();
        $this->indexNumber = $indexNumber;
        $this->SetMargins(10, 10, 10); // Set smaller margins for mobile viewing
    }

    function Header()
    {
        $this->SetFont('Arial', 'B', 18);
        $this->SetTextColor(0, 51, 102);
        $this->Cell(0, 10, 'Proof of Submission', 0, 1, 'C');
        $this->SetFont('Arial', 'I', 12);
        $this->SetTextColor(128, 128, 128);
        $this->Cell(0, 8, 'Generated on: ' . date('d-m-Y'), 0, 1, 'C');
        $this->Ln(5);
    }

    function Footer()
    {
        $this->SetY(-20);
        $this->SetFont('Arial', 'I', 10);
        $this->SetTextColor(128, 128, 128);
        $this->Cell(0, 10, 'Index Number: ' . $this->indexNumber, 0, 0, 'C');
    }

    function AddSectionTitle($title)
    {
        $this->SetFont('Arial', 'B', 16);
        $this->SetFillColor(240, 240, 240);
        $this->Cell(0, 12, $title, 0, 1, 'L', true);
        $this->Ln(3);
    }

    function SubmissionDetails($details)
    {
        $this->SetFont('Arial', '', 13);
        $this->SetFillColor(245, 245, 245);
        $fill = false;
        foreach ($details as $key => $value) {
            $this->Cell(60, 12, $key, 0, 0, 'L', $fill);
            $this->Cell(0, 12, $value, 0, 1, 'L', $fill);
            $fill = !$fill; // Toggle background fill color
        }
        $this->Ln(5); // Add a little space between sections
    }
}

$pdf = new PDF($indexNumber);
$pdf->AddPage();

$pdf->AddSectionTitle('Student Details');
$pdf->SubmissionDetails([
    'Surname' => htmlspecialchars($studentDetails['surname'], ENT_QUOTES, 'UTF-8'),
    'First Name' => htmlspecialchars($studentDetails['first_name'], ENT_QUOTES, 'UTF-8'),
    'Other Names' => htmlspecialchars($studentDetails['other_names'], ENT_QUOTES, 'UTF-8'),
    'Telephone Number' => htmlspecialchars($studentDetails['telephone'], ENT_QUOTES, 'UTF-8'),
    'Email' => htmlspecialchars($studentDetails['email'], ENT_QUOTES, 'UTF-8'),
    'Course of Study' => htmlspecialchars($studentDetails['course'], ENT_QUOTES, 'UTF-8')
]);

$sectionTitle = htmlspecialchars($studentDetails['group'], ENT_QUOTES, 'UTF-8') === 'Industrial Internship' ? 'Organisation Details' : 'School Details';
$pdf->AddSectionTitle($sectionTitle);
$pdf->SubmissionDetails([
    htmlspecialchars($studentDetails['group'], ENT_QUOTES, 'UTF-8') === 'Industrial Internship' ? 'Name of Organisation' : 'Name of School' => htmlspecialchars($studentDetails['organisation_name'], ENT_QUOTES, 'UTF-8'),
    'Number of Months' => htmlspecialchars($studentDetails['months'], ENT_QUOTES, 'UTF-8'),
    'Location' => htmlspecialchars($studentDetails['location'], ENT_QUOTES, 'UTF-8'),
    'Ghana Post GPS/Google Location' => htmlspecialchars($studentDetails['gps_location'], ENT_QUOTES, 'UTF-8'),
    'Region' => htmlspecialchars($studentDetails['region'], ENT_QUOTES, 'UTF-8'),
    'District' => htmlspecialchars($studentDetails['district'], ENT_QUOTES, 'UTF-8')
]);

$pdf->Output('D', 'Proof_of_Submission.pdf');
?>
