<?php
session_start();
ob_start(); // Start output buffering

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

include '../includes/header.php';
include '../config/database.php';

$statusMessage = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $currentPassword = $_POST['currentPassword'];
    $newPassword = $_POST['newPassword'];
    $confirmPassword = $_POST['confirmPassword'];

    if ($newPassword !== $confirmPassword) {
        $_SESSION['statusMessage'] = 'New passwords do not match.';
        header('Location: change_password.php'); // Move header immediately after setting session variable
        exit;
    } else {
        $stmt = $pdo->prepare('SELECT password FROM users WHERE id = ?');
        $stmt->execute([$_SESSION['user_id']]);
        $user = $stmt->fetch();

        if (password_verify($currentPassword, $user['password'])) {
            $newPasswordHash = password_hash($newPassword, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare('UPDATE users SET password = ? WHERE id = ?');
            $stmt->execute([$newPasswordHash, $_SESSION['user_id']]);
            $_SESSION['statusMessage'] = 'Password changed successfully. Please log in again.';
            session_destroy(); // Log out the user
            header('Location: login.php'); // Move header immediately after setting session variable
            exit;
        } else {
            $_SESSION['statusMessage'] = 'Current password is incorrect.';
            header('Location: change_password.php'); // Move header immediately after setting session variable
            exit;
        }
    }
}

if (isset($_SESSION['statusMessage'])) {
    $statusMessage = htmlspecialchars($_SESSION['statusMessage'], ENT_QUOTES, 'UTF-8');
    unset($_SESSION['statusMessage']);
}

ob_end_flush(); // End output buffering
?>

<!-- HTML content -->
<div class="container mt-4">
    <h2>Change Password</h2>
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <?php if ($statusMessage): ?>
                        <div class="alert alert-info" id="statusAlert">
                            <?php echo $statusMessage; ?>
                        </div>
                    <?php endif; ?>
                    <form method="POST" action="change_password.php">
                        <div class="mb-3">
                            <label for="currentPassword" class="form-label">Current Password</label>
                            <input type="password" class="form-control" id="currentPassword" name="currentPassword" required>
                        </div>
                        <div class="mb-3">
                            <label for="newPassword" class="form-label">New Password</label>
                            <input type="password" class="form-control" id="newPassword" name="newPassword" required>
                        </div>
                        <div class="mb-3">
                            <label for="confirmPassword" class="form-label">Confirm New Password</label>
                            <input type="password" class="form-control" id="confirmPassword" name="confirmPassword" required>
                        </div>
                        <button type="submit" class="btn btn-primary">Change Password</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const alertBox = document.getElementById('statusAlert');
        if (alertBox) {
            setTimeout(() => {
                alertBox.style.display = 'none';
            }, 5000);
        }
    });
</script>
