<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Internship Portal</title>
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars('../public/img/sob_logo.png', ENT_QUOTES, 'UTF-8'); ?>">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <style>
        body {
            background: url('<?php echo htmlspecialchars('public/img/index_cover.jpg', ENT_QUOTES, 'UTF-8'); ?>') no-repeat center center fixed;
            background-size: cover;
            height: 100vh;
            margin: 0;
            color: #ffffff;
            text-align: center;
            display: flex;
            justify-content: center;
            align-items: center;
            position: relative;
        }

        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            /* Overlay effect */
            z-index: 1;
        }

        .cover-container {
            position: relative;
            z-index: 2;
            max-width: 42em;
        }

        .btn-secondary {
            border-radius: 0px;
            color: #ffffff;
            border: 2px solid #ffffff;
            background: transparent;
        }

        .btn-secondary:hover {
            background: #ffffff;
            color: #000000;
        }

        footer p {
            color: #cccccc;
        }
    </style>
</head>

<body>
    <div class="cover-container">
        <main class="px-3">
            <h1>Welcome to SOB-IMS</h1>
            <p class="lead">Dear students, this portal is your gateway to registering and submitting your internship
                acceptance letters. We encourage you to use this platform to streamline your internship process. Explore
                the portal to find all necessary resources and guidance for your internship journey.</p>
            <p class="lead">
                <a href="<?php echo htmlspecialchars('student/index', ENT_QUOTES, 'UTF-8'); ?>" class="btn btn-lg btn-secondary fw-bold border-white">Get Started</a>
            </p>
        </main>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>
    <script src="<?php echo htmlspecialchars('js/scripts.js', ENT_QUOTES, 'UTF-8'); ?>"></script>
</body>

</html>
