<?php
session_start();
include '../config/database.php';

// Check if system admin is logged in
if (!isset($_SESSION['sys_admin_id'])) {
    header('Location: login.php');
    exit;
}

// Fetch system admin details
$stmt = $pdo->prepare('SELECT * FROM sys_admin WHERE id = :id');
$stmt->bindParam(':id', $_SESSION['sys_admin_id']);
$stmt->execute();
$admin = $stmt->fetch();

if (!$admin) {
    header('Location: login.php');
    exit;
}

$search = isset($_GET['search']) ? $_GET['search'] : '';

// SQL query to join users and student_details based on user_id
$sql = "SELECT student_details.*, users.index_number 
        FROM student_details 
        JOIN users ON student_details.user_id = users.id 
        WHERE users.index_number LIKE :search";

$stmt = $pdo->prepare($sql);
$searchTerm = '%' . $search . '%';
$stmt->bindParam(':search', $searchTerm, PDO::PARAM_STR);
$stmt->execute();
$result = $stmt;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Search Student by Index Number</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f0f0f0;
            font-family: Arial, sans-serif;
            color: #333;
        }

        .container {
            max-width: 700px;
            margin: 50px auto;
            background-color: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        }

        h2 {
            font-weight: 400;
            text-align: center;
            margin-bottom: 20px;
        }

        .input-group {
            border-radius: 30px;
            margin-bottom: 20px;
        }

        input[type="text"] {
            border-radius: 30px;
            padding: 10px;
            border: 1px solid #ccc;
        }

        button {
            border-radius: 30px;
            padding: 10px 20px;
        }

        .scrollable-list {
            max-height: 300px;
            overflow-y: auto;
            border-top: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 10px 0;
        }

        .list-group-item {
            border: none;
            padding: 10px 15px;
            background-color: #f9f9f9;
            margin-bottom: 8px;
            border-radius: 5px;
            transition: background-color 0.2s ease;
        }

        .list-group-item a {
            color: #333;
            text-decoration: none;
        }

        .list-group-item:hover {
            background-color: #f1f1f1;
        }

        .back-to-dashboard {
            display: inline-block;
            margin-bottom: 15px;
            color: #007bff;
            text-decoration: none;
            font-size: 16px;
            transition: color 0.2s ease;
        }

        .back-to-dashboard:hover {
            color: #0056b3;
        }

        .no-results {
            text-align: center;
            font-size: 16px;
            color: #777;
        }

        .modal-content {
            border-radius: 8px;
            background-color: #fff;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        .modal-header {
            border-bottom: none;
            padding: 15px 20px;
        }

        .modal-title {
            font-weight: 500;
            font-size: 20px;
            color: #333;
        }

        .modal-body {
            padding: 20px;
            font-size: 15px;
            color: #555;
        }

        .modal-body p {
            margin-bottom: 10px;
            word-wrap: break-word;
            word-break: break-all;
        }

        .modal-footer {
            border-top: none;
            padding: 15px 20px;
        }

        .btn-close {
            background-color: transparent;
            border: none;
            color: #333;
            opacity: 0.8;
        }

        .btn-close:hover {
            opacity: 1;
        }

        #pin-input {
            max-width: 150px;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <a href="index" class="back-to-dashboard">← Back to Dashboard</a>
        <h2>Search Student by Index Number</h2>

        <!-- Search Form -->
        <form id="searchForm" method="GET" action="" class="mb-4">
            <div class="input-group">
                <input type="text" id="searchInput" name="search" class="form-control" placeholder="Enter index number" value="<?php echo htmlspecialchars($search, ENT_QUOTES, 'UTF-8'); ?>">
                <button type="submit" class="btn btn-primary ms-2">Search</button>
            </div>
        </form>

        <!-- Display Search Results -->
        <?php if ($result->rowCount() > 0): ?>
        <div class="scrollable-list">
            <ul class="list-group">
                <?php while($row = $result->fetch(PDO::FETCH_ASSOC)): ?>
                <li class="list-group-item">
                    <a href="#" class="student-link" data-bs-toggle="modal" data-bs-target="#studentModal" 
                       data-id="<?php echo $row['id']; ?>"
                       data-userid="<?php echo htmlspecialchars($row['user_id'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-indexnumber="<?php echo htmlspecialchars($row['index_number'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-surname="<?php echo htmlspecialchars($row['surname'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-firstname="<?php echo htmlspecialchars($row['first_name'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-othernames="<?php echo htmlspecialchars($row['other_names'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-telephone="<?php echo htmlspecialchars($row['telephone'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-email="<?php echo htmlspecialchars($row['email'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-course="<?php echo htmlspecialchars($row['course'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-group="<?php echo htmlspecialchars($row['group'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-organisation="<?php echo htmlspecialchars($row['organisation_name'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-months="<?php echo htmlspecialchars($row['months'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-location="<?php echo htmlspecialchars($row['location'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-gps="<?php echo htmlspecialchars($row['gps_location'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-region="<?php echo htmlspecialchars($row['region'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-district="<?php echo htmlspecialchars($row['district'], ENT_QUOTES, 'UTF-8'); ?>"
                       data-status="<?php echo htmlspecialchars($row['status'], ENT_QUOTES, 'UTF-8'); ?>">
                       <?php echo "Index Number: " . htmlspecialchars($row['index_number'], ENT_QUOTES, 'UTF-8') . " - " . htmlspecialchars($row['surname'], ENT_QUOTES, 'UTF-8') . ' ' . htmlspecialchars($row['first_name'], ENT_QUOTES, 'UTF-8'); ?>
                    </a>
                </li>
                <?php endwhile; ?>
            </ul>
        </div>
        <?php else: ?>
        <p class="no-results">No results found</p>
        <?php endif; ?>
    </div>

    <!-- Student Details Modal -->
    <div class="modal fade" id="studentModal" tabindex="-1" aria-labelledby="studentModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="studentModalLabel">Student Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><strong>Index Number:</strong> <span id="modal-indexnumber"></span></p>
                    <p><strong>Surname:</strong> <span id="modal-surname"></span></p>
                    <p><strong>First Name:</strong> <span id="modal-firstname"></span></p>
                    <p><strong>Other Names:</strong> <span id="modal-othernames"></span></p>
                    <p><strong>Telephone:</strong> <span id="modal-telephone"></span></p>
                    <p><strong>Email:</strong> <span id="modal-email"></span></p>
                    <p><strong>Course:</strong> <span id="modal-course"></span></p>
                    <p><strong>Group:</strong> <span id="modal-group"></span></p>
                    <p><strong>Organisation:</strong> <span id="modal-organisation"></span></p>
                    <p><strong>Months:</strong> <span id="modal-months"></span></p>
                    <p><strong>Location:</strong> <span id="modal-location"></span></p>
                    <p><strong>GPS Location:</strong> <span id="modal-gps"></span></p>
                    <p><strong>Region:</strong> <span id="modal-region"></span></p>
                    <p><strong>District:</strong> <span id="modal-district"></span></p>
                    <p><strong>Status:</strong> <span id="modal-status"></span></p>
                </div>
                <div class="modal-footer">
                    <input type="password" id="pin-input" class="form-control me-3" placeholder="Enter PIN">
                    <button type="button" class="btn btn-danger" id="delete-student">Delete Student</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        var searchInput = document.getElementById('searchInput');
        var searchForm = document.getElementById('searchForm');

        // Automatically submit the form if the input field is cleared
        searchInput.addEventListener('input', function() {
            if (searchInput.value === '') {
                searchForm.submit();
            }
        });

        var studentLinks = document.querySelectorAll('.student-link');
        var studentId;

        // Open modal and populate data
        studentLinks.forEach(function(link) {
            link.addEventListener('click', function() {
                studentId = this.getAttribute('data-id');
                document.getElementById('modal-indexnumber').textContent = this.getAttribute('data-indexnumber');
                document.getElementById('modal-surname').textContent = this.getAttribute('data-surname');
                document.getElementById('modal-firstname').textContent = this.getAttribute('data-firstname');
                document.getElementById('modal-othernames').textContent = this.getAttribute('data-othernames');
                document.getElementById('modal-telephone').textContent = this.getAttribute('data-telephone');
                document.getElementById('modal-email').textContent = this.getAttribute('data-email');
                document.getElementById('modal-course').textContent = this.getAttribute('data-course');
                document.getElementById('modal-group').textContent = this.getAttribute('data-group');
                document.getElementById('modal-organisation').textContent = this.getAttribute('data-organisation');
                document.getElementById('modal-months').textContent = this.getAttribute('data-months');
                document.getElementById('modal-location').textContent = this.getAttribute('data-location');
                document.getElementById('modal-gps').textContent = this.getAttribute('data-gps');
                document.getElementById('modal-region').textContent = this.getAttribute('data-region');
                document.getElementById('modal-district').textContent = this.getAttribute('data-district');
                document.getElementById('modal-status').textContent = this.getAttribute('data-status');
            });
        });

        // Handle Delete Student with PIN
        document.getElementById('delete-student').addEventListener('click', function() {
            var pin = document.getElementById('pin-input').value;
            var correctPin = 'Tigos';  // Replace this with a server-side check in a real application

            if (pin === correctPin) {
                if (confirm('Are you sure you want to delete this student?')) {
                    var xhr = new XMLHttpRequest();
                    xhr.open('POST', 'delete_student.php', true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                    xhr.onload = function() {
                        if (xhr.status === 200) {
                            alert('Student deleted successfully');
                            location.reload();
                        } else {
                            alert('Error deleting student');
                        }
                    };
                    xhr.send('id=' + studentId);
                }
            } else {
                alert('Incorrect PIN. Please try again.');
            }
        });
    });
    </script>
</body>
</html>
