<?php
include '../config/database.php';

if (isset($_POST['id'])) {
    $studentId = $_POST['id'];

    // Fetch student details to get the uploaded file path
    $stmt = $pdo->prepare("SELECT acceptance_letter FROM student_details WHERE id = :id");
    $stmt->bindParam(':id', $studentId);
    $stmt->execute();
    $student = $stmt->fetch();

    if ($student) {
        // Full path to the uploaded file
        $file = $student['acceptance_letter'];
        
        // Check if the file exists and delete it
        if ($file && file_exists(__DIR__ . '/../uploads/' . $file)) {
            unlink(__DIR__ . '/../uploads/' . $file); // Deletes the file from the 'uploads' folder
        }

        // Delete student from the database
        $stmt = $pdo->prepare("DELETE FROM student_details WHERE id = :id");
        $stmt->bindParam(':id', $studentId);
        $stmt->execute();

        echo "Student deleted successfully";
    } else {
        echo "Student not found";
    }
}
