<?php
session_start();
include('../config/database.php');

// Check if the system admin is logged in
if (!isset($_SESSION['sys_admin_id'])) {
    header('Location: ../status/login.php');
    exit;
}

// Handle submission completion and GPS location update request
if (isset($_POST['complete_submission'])) {
    $user_id = $_POST['user_id'];
    $new_gps_location = $_POST['gps_location'];
    $acceptance_letter = $_FILES['acceptance_letter']['name'];

    // Fetch the user's index number from the users table
    $index_query = "SELECT index_number FROM users WHERE id = ?";
    $index_stmt = $pdo->prepare($index_query);
    $index_stmt->execute([$user_id]);
    $index_row = $index_stmt->fetch();
    $index_number = $index_row['index_number'];

    // Check if a new acceptance letter was uploaded
    if (!empty($acceptance_letter)) {
        $target_dir = "../uploads/";
        $file_type = pathinfo($acceptance_letter, PATHINFO_EXTENSION);

        // Rename the file to the user's index number
        $target_file = $target_dir . $index_number . '.' . $file_type;

        // Check if the uploaded file is a PDF or JPG
        if ($file_type != "pdf" && $file_type != "jpg" && $file_type != "jpeg") {
            $message = "Only PDF or JPG files are allowed.";
        } else {
            if (move_uploaded_file($_FILES['acceptance_letter']['tmp_name'], $target_file)) {
                // Update the student details in the database with the new file name
                $update_query = "UPDATE student_details SET status = 'submitted', acceptance_letter = ?, gps_location = ? WHERE user_id = ?";
                $stmt = $pdo->prepare($update_query);
                if ($stmt->execute([basename($target_file), $new_gps_location, $user_id])) {
                    $message = "Submission and GPS Location updated successfully!";
                } else {
                    $message = "Error completing submission.";
                }
            } else {
                $message = "Error uploading the file.";
            }
        }
    } else {
        // Update the student details without changing the acceptance letter
        $update_query = "UPDATE student_details SET status = 'submitted', gps_location = ? WHERE user_id = ?";
        $stmt = $pdo->prepare($update_query);
        if ($stmt->execute([$new_gps_location, $user_id])) {
            $message = "Submission and GPS Location updated successfully!";
        } else {
            $message = "Error completing submission.";
        }
    }
}

// Handle search request
$search_index_number = '';
if (isset($_POST['search'])) {
    $search_index_number = trim($_POST['index_number']);
}

// Fetch details of students with "saved" status or search by index number
if (!empty($search_index_number)) {
    $query = "SELECT sd.*, u.index_number FROM student_details sd JOIN users u ON sd.user_id = u.id WHERE sd.status = 'saved' AND u.index_number = ?";
    $stmt = $pdo->prepare($query);
    $stmt->execute([$search_index_number]);
    $result = $stmt;
} else {
    $query = "SELECT sd.*, u.index_number FROM student_details sd JOIN users u ON sd.user_id = u.id WHERE sd.status = 'saved'";
    $result = $pdo->query($query);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Search Student by Index Number</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
            background-color: #f7f7f7;
            color: #333;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            max-width: 700px;
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            padding: 20px;
            margin: 20px;
        }
        .back-btn {
            font-size: 14px;
            color: #007bff;
            text-decoration: none;
            margin-bottom: 15px;
            display: inline-block;
        }
        h2 {
            font-weight: 600;
            font-size: 1.5rem;
            text-align: center;
            margin-bottom: 20px;
        }
        .input-group {
            margin-bottom: 15px;
        }
        .input-group .form-control {
            border-radius: 50px;
            padding: 10px 20px;
        }
        .input-group .btn {
            border-radius: 50px;
            padding: 10px 20px;
        }
        .result-list {
            list-style: none;
            padding: 0;
            margin: 0;
            max-height: 300px;
            overflow-y: auto;
            border: 1px solid #ddd;
            border-radius: 8px;
        }
        .result-list li {
            padding: 10px 15px;
            border-bottom: 1px solid #f1f1f1;
            font-size: 0.9rem;
            color: #555;
        }
        .result-list li:last-child {
            border-bottom: none;
        }
        .result-list li:hover {
            background-color: #f9f9f9;
        }
    </style>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const alertBox = document.querySelector(".alert-info");
            if (alertBox) {
                setTimeout(() => {
                    alertBox.style.display = "none";
                }, 5000); // Hide after 5 seconds (5000 milliseconds)
            }
        });
    </script>
</head>
<body>
<div class="container">
    <a href="index" class="back-btn">← Back to Dashboard</a>
    <h2>Complete Student Submissions</h2>

    <?php if (isset($message)): ?>
        <div class="alert alert-info text-center">
            <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>
    
    <form method="post" action="">
        <div class="input-group">
            <input type="text" name="index_number" class="form-control" placeholder="Enter index number" value="<?php echo htmlspecialchars($search_index_number); ?>">
            <button type="submit" name="search" class="btn btn-primary">Search</button>
        </div>
    </form>

    <ul class="result-list">
        <?php
        if ($result->rowCount() > 0) {
            while ($row = $result->fetch()) {
                echo "<li><strong>Index Number:</strong> " . htmlspecialchars($row['index_number'], ENT_QUOTES, 'UTF-8') . " - " . htmlspecialchars($row['first_name'], ENT_QUOTES, 'UTF-8') . " " . htmlspecialchars($row['surname'], ENT_QUOTES, 'UTF-8');
                echo "<form method='post' enctype='multipart/form-data' style='margin-top: 10px;'>";
                echo "<input type='hidden' name='user_id' value='" . $row['user_id'] . "'>";
                echo "<div class='mb-2'><label><strong>GPS Location:</strong></label>";
                echo "<input type='text' name='gps_location' class='form-control' value='" . htmlspecialchars($row['gps_location'], ENT_QUOTES, 'UTF-8') . "' required></div>";
                echo "<div class='mb-2'><label><strong>Acceptance Letter:</strong></label>";
                
                if ($row['acceptance_letter']) {
                    echo "<a href='../uploads/" . htmlspecialchars($row['acceptance_letter'], ENT_QUOTES, 'UTF-8') . "' target='_blank'>View Existing Letter</a>";
                } else {
                    echo "Not Uploaded";
                }

                echo "<input type='file' name='acceptance_letter' class='form-control mt-2' accept='.pdf, .jpg, .jpeg'></div>";
                echo "<button type='submit' name='complete_submission' class='btn btn-success btn-sm'>Complete Submission</button>";
                echo "</form></li>";
            }
        } else {
            echo "<li class='text-center'>No students found with saved status or matching index number.</li>";
        }
        ?>
    </ul>
</div>
</body>
</html>
