<?php
ob_start();
session_start();
require_once __DIR__ . '/../config/database.php';

// Mobile device detection
function isMobileDevice() {
    return preg_match('/android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini/i', $_SERVER['HTTP_USER_AGENT']);
}

if (isMobileDevice()) {
    echo '<!DOCTYPE html><html><head><meta name="viewport" content="width=device-width, initial-scale=1"><title>Desktop Only</title><style>body{font-family:sans-serif;text-align:center;padding:40px;} .alert{display:inline-block;margin-top:100px;padding:30px 40px;background:#fff3cd;border:1px solid #ffeeba;border-radius:8px;color:#856404;font-size:1.3rem;}</style></head><body><div class="alert">This page is only accessible on desktop devices. Please use a desktop or laptop computer to access this page.</div></body></html>';
    exit;
}

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Generate CSRF token if it doesn't exist
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$userId = $_SESSION['user_id'];

// Fetch any already-submitted report
$stmt = $pdo->prepare("
  SELECT *
    FROM teaching_reports
   WHERE user_id = ? 
     AND status = 'submitted'
   LIMIT 1
");
$stmt->execute([$userId]);
$submittedReport = $stmt->fetch(PDO::FETCH_ASSOC);

$formDisabled = (bool)$submittedReport;
$justSubmitted = isset($_GET['submit']);

include __DIR__ . '/../includes/header.php';
?>

<link rel="stylesheet" href="/public/css/bootstrap.min.css">

<style>
  .container { max-width:850px; }
  .presentation-preview { width: 100%; height: 500px; border: 1px solid #ddd; border-radius: 4px; }
</style>

<div class="container mt-5 mb-5">
  <h2 class="mb-4">Teaching Internship Report</h2>

  <?php if($justSubmitted): ?>
    <div class="alert alert-success" id="submitAlert">
      <strong>Report Submitted!</strong> Thank you.
    </div>
  <?php endif; ?>

  <?php if($formDisabled): ?>
    <div class="alert alert-warning">
      <h5>You've already submitted—editing disabled.</h5>
      <button class="btn btn-info mt-2" data-bs-toggle="modal" data-bs-target="#reviewModal">
        View Submission
      </button>
    </div>
  <?php endif; ?>

  <!-- FORM -->
  <?php if(!$formDisabled): ?>
  <form id="reportForm"
        action="submit_teaching_report.php"
        method="POST"
        enctype="multipart/form-data"
        novalidate>
    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token']); ?>">
    
    <!-- PowerPoint Presentation Upload -->
    <div class="mb-4">
      <label for="presentation" class="form-label">Teaching Presentation (PowerPoint)</label>
      <input type="file" id="presentation" name="presentation" class="form-control"
             accept=".ppt,.pptx" required>
      <div class="form-text">Upload your PowerPoint presentation file (.ppt or .pptx)</div>
    </div>

    <!-- CV Upload -->
    <div class="mb-3">
      <label for="cv" class="form-label">Curriculum Vitae (PDF/DOC)</label>
      <input type="file" id="cv" name="cv" class="form-control"
             accept=".pdf,.doc,.docx" required>
    </div>

    <button type="submit" class="btn btn-success">Submit Report</button>
  </form>
  <?php endif; ?>
</div>

<?php if ($formDisabled && is_array($submittedReport)): ?>
<!-- Review Modal -->
<div class="modal fade" id="reviewModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5>Your Submitted Report</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <h6>Teaching Presentation</h6>
        <?php if (isset($submittedReport['presentation_path'])): ?>
          <div class="presentation-preview">
            <iframe src="https://view.officeapps.live.com/op/embed.aspx?src=<?= urlencode($_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . '/uploads/presentations/' . basename($submittedReport['presentation_path'])) ?>" 
                    width="100%" height="100%" frameborder="0"></iframe>
          </div>
        <?php endif; ?>

        <h6 class="mt-4">CV</h6>
        <?php if (isset($submittedReport['cv_path']) && strtolower(pathinfo($submittedReport['cv_path'], PATHINFO_EXTENSION)) === 'pdf'): ?>
          <p>
            <button type="button" class="btn btn-link" data-bs-toggle="modal" data-bs-target="#cvViewModal">View CV</button>
          </p>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>

<?php if (isset($submittedReport['cv_path']) && strtolower(pathinfo($submittedReport['cv_path'], PATHINFO_EXTENSION)) === 'pdf'): ?>
<!-- CV View Modal -->
<div class="modal fade" id="cvViewModal" tabindex="-1" aria-labelledby="cvViewModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl" style="max-width:90vw;">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="cvViewModalLabel">View CV</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" style="height:80vh;">
        <iframe src="../uploads/cvs/<?= htmlspecialchars(basename($submittedReport['cv_path'])) ?>" style="width:100%;height:100%;" frameborder="0"></iframe>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>

<script src="/public/js/bootstrap.bundle.min.js"></script>
<script>
  document.addEventListener('DOMContentLoaded', function() {
    setTimeout(function() {
      var alert = document.getElementById('submitAlert');
      if (alert) {
        alert.style.transition = "opacity 0.5s";
        alert.style.opacity = 0;
        setTimeout(function() {
          alert.style.display = 'none';
        }, 500);
      }
    }, 3000);
  });
</script>

<?php include __DIR__ . '/../includes/footer.php'; ob_end_flush(); ?>
