<?php
include '../config/database.php';
include '../includes/functions.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get current academic year
    $currentYearKey = 'current_academic_year';
    $stmtCurrentYear = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $stmtCurrentYear->execute([$currentYearKey]);
    $currentYearSetting = $stmtCurrentYear->fetch(PDO::FETCH_ASSOC);
    $currentAcademicYear = $currentYearSetting ? $currentYearSetting['setting_value'] : '2024-2025';
    
    // Check registration period first
    $deadlineKey = 'registration_end_date_' . $currentAcademicYear;
    $startDateKey = 'registration_start_date_' . $currentAcademicYear;
    
    $stmtDeadline = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $stmtDeadline->execute([$deadlineKey]);
    $deadlineSetting = $stmtDeadline->fetch(PDO::FETCH_ASSOC);
    
    $stmtStartDate = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $stmtStartDate->execute([$startDateKey]);
    $startDateSetting = $stmtStartDate->fetch(PDO::FETCH_ASSOC);
    
    $currentTime = time();
    
    // Check manual registration status first
    $registrationStatusKey = 'registration_status_' . $currentAcademicYear;
    $stmtStatus = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $stmtStatus->execute([$registrationStatusKey]);
    $statusSetting = $stmtStatus->fetch(PDO::FETCH_ASSOC);
    $manualRegistrationStatus = $statusSetting ? $statusSetting['setting_value'] : 'auto';
    
    if ($manualRegistrationStatus === 'closed') {
        header('Location: register.php?error=registration_manually_closed');
        exit;
    } elseif ($manualRegistrationStatus === 'open') {
        // Registration is manually open, skip date checks
    } else {
        // Check automatic date-based registration
        // Check if registration has started
        if ($startDateSetting && !empty($startDateSetting['setting_value'])) {
            $startDate = strtotime($startDateSetting['setting_value']);
            if ($currentTime < $startDate) {
                header('Location: register.php?error=registration_not_open');
                exit;
            }
        }
        
        // Check if registration has ended
        if ($deadlineSetting && !empty($deadlineSetting['setting_value'])) {
            $deadline = strtotime($deadlineSetting['setting_value']);
            if ($currentTime > $deadline) {
                header('Location: register.php?error=registration_period_passed');
                exit;
            }
        }
    }

    // Sanitize and escape the input fields
    $indexNumber = htmlspecialchars(trim($_POST['indexNumber']), ENT_QUOTES, 'UTF-8');
    $password = htmlspecialchars(trim($_POST['password']), ENT_QUOTES, 'UTF-8');
    $confirmPassword = htmlspecialchars(trim($_POST['confirmPassword']), ENT_QUOTES, 'UTF-8');
    $group = htmlspecialchars(trim($_POST['group']), ENT_QUOTES, 'UTF-8');
    $securityQuestion = htmlspecialchars(trim($_POST['securityQuestion']), ENT_QUOTES, 'UTF-8');
    $securityAnswer = htmlspecialchars(trim($_POST['securityAnswer']), ENT_QUOTES, 'UTF-8');

    if ($password !== $confirmPassword) {
        header('Location: register.php?error=password_mismatch');
        exit;
    }

    // Check if the index number is in the valid_index_numbers table for the current academic year
    $stmt = $pdo->prepare('SELECT * FROM valid_index_numbers WHERE index_number = ? AND academic_year = ?');
    $stmt->execute([$indexNumber, $currentAcademicYear]);
    $validIndex = $stmt->fetch();

    if ($validIndex) {
        // Register the user
        if (registerUser($pdo, $indexNumber, $password, $group, $securityQuestion, $securityAnswer, $currentAcademicYear)) {
            // Log the registration action
            log_action(
                null, // No user ID since it's a new registration
                $indexNumber, // Use the new index number as the username
                "User Registered: $indexNumber for academic year $currentAcademicYear", // Log message
                'users', // Affected table
                null, // No specific row ID
                null, // Old values (none since it's a new registration)
                ['index_number' => $indexNumber, 'group' => $group, 'academic_year' => $currentAcademicYear, 'security_question' => $securityQuestion] // New values
            );

            header('Location: login.php');
        } else {
            header('Location: register.php?error=index_exists');
        }
    } else {
        header('Location: register.php?error=index_not_found');
    }
}
?>
