<?php
include '../includes/header.php';
include '../config/database.php';

// Get current academic year
$currentYearKey = 'current_academic_year';
$stmtCurrentYear = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
$stmtCurrentYear->execute([$currentYearKey]);
$currentYearSetting = $stmtCurrentYear->fetch(PDO::FETCH_ASSOC);
$currentAcademicYear = $currentYearSetting ? $currentYearSetting['setting_value'] : '2024-2025';

// Get registration deadline for current academic year
$deadlineKey = 'registration_end_date_' . $currentAcademicYear;
$stmtDeadline = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
$stmtDeadline->execute([$deadlineKey]);
$deadlineSetting = $stmtDeadline->fetch(PDO::FETCH_ASSOC);
$registrationDeadline = $deadlineSetting ? $deadlineSetting['setting_value'] : '';

// Get registration start date for current academic year
$startDateKey = 'registration_start_date_' . $currentAcademicYear;
$stmtStartDate = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
$stmtStartDate->execute([$startDateKey]);
$startDateSetting = $stmtStartDate->fetch(PDO::FETCH_ASSOC);
$registrationStartDate = $startDateSetting ? $startDateSetting['setting_value'] : '';

// Check if registration is currently open
$currentTime = time();
$registrationOpen = true;
$registrationMessage = '';

// First check manual registration status
$registrationStatusKey = 'registration_status_' . $currentAcademicYear;
$stmtStatus = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
$stmtStatus->execute([$registrationStatusKey]);
$statusSetting = $stmtStatus->fetch(PDO::FETCH_ASSOC);
$manualRegistrationStatus = $statusSetting ? $statusSetting['setting_value'] : 'auto';

if ($manualRegistrationStatus === 'closed') {
    $registrationOpen = false;
    $registrationMessage = 'Registration is manually closed for ' . $currentAcademicYear . '. Please contact the administrator for assistance.';
} elseif ($manualRegistrationStatus === 'open') {
    $registrationOpen = true;
    $registrationMessage = '';
} else {
    // Check automatic date-based registration
    if ($startDateSetting && !empty($startDateSetting['setting_value'])) {
        $startDate = strtotime($startDateSetting['setting_value']);
        if ($currentTime < $startDate) {
            $registrationOpen = false;
            $registrationMessage = 'Registration is not yet open for ' . $currentAcademicYear . '. Please wait until the registration period begins.';
        }
    }

    if ($deadlineSetting && !empty($deadlineSetting['setting_value'])) {
        $deadline = strtotime($deadlineSetting['setting_value']);
        if ($currentTime > $deadline) {
            $registrationOpen = false;
            $registrationMessage = 'Registration period for ' . $currentAcademicYear . ' has ended. Please contact the administrator for assistance.';
        }
    }
}
?>

<div class="container mt-5 content-container d-flex justify-content-center">
    <div class="card w-100" style="max-width: 600px;">
        <div class="card-header">
            <h2><?php echo $registrationOpen ? 'Register' : 'Registration Closed'; ?></h2>
        </div>
        <div class="card-body">
            <?php if ($registrationStartDate && $registrationDeadline): ?>
                <div class="alert alert-info">
                    <strong>Registration Period for <?php echo $currentAcademicYear; ?>:</strong> <?php echo date('F j, Y \a\t g:i A', strtotime($registrationStartDate)); ?> - <?php echo date('F j, Y \a\t g:i A', strtotime($registrationDeadline)); ?>
                </div>
            <?php elseif ($registrationStartDate): ?>
                <div class="alert alert-info">
                    <strong>Registration Opens for <?php echo $currentAcademicYear; ?>:</strong> <?php echo date('F j, Y \a\t g:i A', strtotime($registrationStartDate)); ?>
                </div>
            <?php elseif ($registrationDeadline): ?>
                <div class="alert alert-info">
                    <strong>Registration Deadline for <?php echo $currentAcademicYear; ?>:</strong> <?php echo date('F j, Y \a\t g:i A', strtotime($registrationDeadline)); ?>
                </div>
            <?php endif; ?>
            
            <?php if (!$registrationOpen): ?>
                <div class="alert alert-warning">
                    <strong>Registration Closed:</strong> <?php echo $registrationMessage; ?>
                </div>
            <?php endif; ?>
            
            <?php if (isset($_GET['error'])): ?>
                <div class="alert alert-danger">
                    <?php
                    if ($_GET['error'] === 'index_not_found') {
                        echo "Index number cannot be found.";
                    } elseif ($_GET['error'] === 'password_mismatch') {
                        echo "Passwords do not match.";
                    } elseif ($_GET['error'] === 'index_exists') {
                        echo "Index number already exists.";
                    } elseif ($_GET['error'] === 'deadline_passed') {
                        echo "Registration deadline has passed. Please contact the administrator for assistance.";
                    } elseif ($_GET['error'] === 'registration_not_open') {
                        echo "Registration is not yet open. Please wait until the registration period begins.";
                    } elseif ($_GET['error'] === 'registration_period_passed') {
                        echo "Registration period has ended. Please contact the administrator for assistance.";
                    } elseif ($_GET['error'] === 'registration_manually_closed') {
                        echo "Registration is manually closed. Please contact the administrator for assistance.";
                    }
                    ?>
                </div>
            <?php endif; ?>
            <form method="POST" action="register_action" <?php echo !$registrationOpen ? 'style="display: none;"' : ''; ?>>
                <div class="mb-3">
                    <label for="indexNumber" class="form-label">Index Number</label>
                    <input type="text" class="form-control" id="indexNumber" name="indexNumber" required <?php echo !$registrationOpen ? 'disabled' : ''; ?>>
                </div>
                <div class="mb-3">
                    <label for="password" class="form-label">Password</label>
                    <div class="input-group">
                        <input type="password" class="form-control" id="password" name="password" required <?php echo !$registrationOpen ? 'disabled' : ''; ?>>
                        <span class="input-group-text" id="togglePassword">
                            <i class="fas fa-eye"></i>
                        </span>
                    </div>
                </div>
                <div class="mb-3">
                    <label for="confirmPassword" class="form-label">Confirm Password</label>
                    <div class="input-group">
                        <input type="password" class="form-control" id="confirmPassword" name="confirmPassword" required <?php echo !$registrationOpen ? 'disabled' : ''; ?>>
                        <span class="input-group-text" id="toggleConfirmPassword">
                            <i class="fas fa-eye"></i>
                        </span>
                    </div>
                </div>
                <div class="mb-3">
                    <label for="group" class="form-label">Internship Group</label>
                    <select class="form-control" id="group" name="group" required <?php echo !$registrationOpen ? 'disabled' : ''; ?>>
                        <option value="" disabled selected>Select your internship group</option>
                        <option value="Industrial Internship">Industrial Internship</option>
                        <option value="Teaching Practice">Teaching Practice</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="securityQuestion" class="form-label">Security Question</label>
                    <select class="form-control" id="securityQuestion" name="securityQuestion" required <?php echo !$registrationOpen ? 'disabled' : ''; ?>>
                        <option value="" disabled selected>Select a security question</option>
                        <option value="What is your mother's maiden name?">What is your mother's maiden name?</option>
                        <option value="What was the name of your first pet?">What was the name of your first pet?</option>
                        <option value="In which city were you born?">In which city were you born?</option>
                        <option value="What was your childhood nickname?">What was your childhood nickname?</option>
                        <option value="What is the name of the street you grew up on?">What is the name of the street you grew up on?</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="securityAnswer" class="form-label">Security Answer</label>
                    <input type="text" class="form-control" id="securityAnswer" name="securityAnswer" required <?php echo !$registrationOpen ? 'disabled' : ''; ?>>
                </div>
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary" <?php echo !$registrationOpen ? 'disabled' : ''; ?>>
                        <?php echo $registrationOpen ? 'Register' : 'Registration Closed'; ?>
                    </button>
                </div>
            </form>
            
            <?php if (!$registrationOpen): ?>
                <div class="text-center mt-3">
                    <a href="login.php" class="btn btn-secondary">Go to Login</a>
                </div>
            <?php endif; ?>
            <div class="mt-3">
                <p>Already have an account? <a href="login">Click here to login</a>.</p>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

<script>
    document.getElementById('togglePassword').addEventListener('click', function () {
        const passwordField = document.getElementById('password');
        const icon = this.querySelector('i');
        if (passwordField.type === 'password') {
            passwordField.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            passwordField.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    });

    document.getElementById('toggleConfirmPassword').addEventListener('click', function () {
        const passwordField = document.getElementById('confirmPassword');
        const icon = this.querySelector('i');
        if (passwordField.type === 'password') {
            passwordField.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            passwordField.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    });

// Prevent form submission when registration is closed
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('form');
    const isRegistrationOpen = <?php echo $registrationOpen ? 'true' : 'false'; ?>;
    
    if (!isRegistrationOpen) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            alert('Registration is currently closed. Please contact the administrator for assistance.');
            return false;
        });
    }
});
</script>
