<?php
session_start();
header('Content-Type: application/json');
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'Not logged in']);
    exit;
}

include '../config/database.php';

$userId = $_SESSION['user_id'];

$stmt = $pdo->prepare('SELECT lecturer_group_id FROM student_details WHERE user_id = ?');
$stmt->execute([$userId]);
$student = $stmt->fetch(PDO::FETCH_ASSOC);

$response = [
    'groupName' => null,
    'supervisors' => [],
    'assigned' => false
];

if ($student && !empty($student['lecturer_group_id'])) {
    $groupId = $student['lecturer_group_id'];
    $stmt = $pdo->prepare('SELECT group_name FROM pi_lecturer_groups WHERE id = ?');
    $stmt->execute([$groupId]);
    $group = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($group) {
        $response['groupName'] = $group['group_name'];
        $response['assigned'] = true;
    }
    $stmt = $pdo->prepare('SELECT name FROM lecturer_login WHERE group_id = ?');
    $stmt->execute([$groupId]);
    $response['supervisors'] = $stmt->fetchAll(PDO::FETCH_COLUMN);
}

echo json_encode($response); 