<?php
include '../config/database.php';

if (isset($_GET['region'])) {
    // Sanitize the 'region' parameter using htmlspecialchars
    $region = htmlspecialchars($_GET['region'], ENT_QUOTES, 'UTF-8');
    
    // Prepare and execute the SQL statement
    $stmt = $pdo->prepare('SELECT district FROM districts WHERE region = ?');
    $stmt->execute([$region]);
    $districts = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Sanitize each district name before encoding it to JSON
    foreach ($districts as &$district) {
        $district['district'] = htmlspecialchars($district['district'], ENT_QUOTES, 'UTF-8');
    }
    
    echo json_encode($districts);
}
