<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require '../config/database.php'; // Include database connection

// Initialize message variables
$msg = "";
$msg_type = "";

// Handle Create Request
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['create_group'])) {
    $group_name = trim($_POST['group_name']);
    $category = $_POST['category'] ?? 'Industrial Internship';

    if (!empty($group_name)) {
        try {
            $sql = "INSERT INTO pi_lecturer_groups (group_name, category) VALUES (:group_name, :category)";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':group_name', $group_name);
            $stmt->bindParam(':category', $category);
            $stmt->execute();

            $msg = "Group created successfully!";
            $msg_type = "success";
        } catch (PDOException $e) {
            $msg = "Database Error: " . $e->getMessage();
            $msg_type = "danger";
        }
    } else {
        $msg = "Error: Group name cannot be empty!";
        $msg_type = "warning";
    }
}

// Handle Delete Request
if (isset($_GET['delete_id'])) {
    $delete_id = $_GET['delete_id'];
    try {
        $sql = "DELETE FROM pi_lecturer_groups WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $delete_id, PDO::PARAM_INT);
        $stmt->execute();

        $msg = "Group deleted successfully!";
        $msg_type = "success";
    } catch (PDOException $e) {
        $msg = "Error deleting group: " . $e->getMessage();
        $msg_type = "danger";
    }

    // Redirect to avoid re-submitting the delete request on refresh
    header("Location: view_groups.php?msg={$msg}&msg_type={$msg_type}");
    exit();
}

// If redirected with query params
if (isset($_GET['msg']) && isset($_GET['msg_type'])) {
    $msg = $_GET['msg'];
    $msg_type = $_GET['msg_type'];
}

// Fetch all groups
try {
    $sql = "SELECT * FROM pi_lecturer_groups ORDER BY id DESC";
    $stmt = $pdo->query($sql);
    $groups = $stmt->fetchAll();
} catch (PDOException $e) {
    $msg = "Error fetching groups: " . $e->getMessage();
    $msg_type = "danger";
}

include('pi_header.php');
?>

<div class="container mt-5">
    <!-- Display Alert if $msg is set -->
    <?php if (!empty($msg)): ?>
        <div 
            id="alert-message" 
            class="alert alert-<?php echo htmlspecialchars($msg_type); ?> alert-dismissible fade show" 
            role="alert"
        >
            <?php echo htmlspecialchars($msg); ?>
        </div>
    <?php endif; ?>

    <div class="row justify-content-center">
        <!-- Adjust col-md-6 to reduce the width of the card -->
        <div class="col-md-6">
            <div class="card shadow-lg p-4">
                <h2 class="mb-4">Manage Lecturer Groups</h2>
                <form method="post" class="mb-4">
                    <div class="mb-3">
                        <label for="group_name" class="form-label">Group Name</label>
                        <input 
                            type="text" 
                            name="group_name" 
                            id="group_name" 
                            class="form-control" 
                            placeholder="Enter Group Name" 
                            required
                        >
                    </div>
                    <div class="mb-3">
                        <label for="category" class="form-label">Category</label>
                        <select name="category" id="category" class="form-select">
                            <option value="Industrial Internship">Industrial Internship</option>
                            <option value="Teaching Practice">Teaching Practice</option>
                        </select>
                    </div>
                    <button type="submit" name="create_group" class="btn btn-primary">Create Group</button>
                </form>
            </div>
        </div>
    </div>

    <!-- Table for Displaying Groups -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card shadow-lg">
                <div class="card-header">
                    <h4 class="mb-0">Existing Groups</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                <thead>
                    <tr>
                                    <th>ID</th>
                        <th>Group Name</th>
                                    <th>Category</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                                <?php if (!empty($groups)): ?>
                    <?php foreach ($groups as $group): ?>
                        <tr>
                                            <td><?= htmlspecialchars($group['id']) ?></td>
                                            <td><?= htmlspecialchars($group['group_name']) ?></td>
                            <td>
                                                <span class="badge <?= $group['category'] === 'Teaching Practice' ? 'bg-primary' : 'bg-success' ?>">
                                                    <?= htmlspecialchars($group['category']) ?>
                                                </span>
                                            </td>
                                            <td>
                                                <a href="edit_group.php?id=<?= $group['id'] ?>" 
                                                   class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-edit"></i> Edit
                                </a>
                                                <a href="?delete_id=<?= $group['id'] ?>" 
                                                   class="btn btn-sm btn-outline-danger"
                                                   onclick="return confirm('Are you sure you want to delete this group?')">
                                                    <i class="fas fa-trash"></i> Delete
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="4" class="text-center">No groups found.</td>
                                    </tr>
                                <?php endif; ?>
                </tbody>
            </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript to auto-hide the alert after 3 seconds -->
<script>
    setTimeout(function() {
        let alertEl = document.getElementById('alert-message');
        if (alertEl) {
            alertEl.remove();
        }
    }, 3000);
</script>

<?php include('pi_footer.php'); ?>
