<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

include '../config/database.php'; // Database connection

$successMessage = '';
$errorMessage = '';

// Retrieve the persistent setting from the database
$settingKey = 'post_internship_active';
$stmtSetting = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
$stmtSetting->execute([$settingKey]);
$setting = $stmtSetting->fetch(PDO::FETCH_ASSOC);
$postInternshipActive = ($setting && $setting['setting_value'] === '1') ? true : false;

// Handle success and error messages from session
if (isset($_SESSION['successMessage'])) {
    $successMessage = $_SESSION['successMessage'];
    unset($_SESSION['successMessage']);
}
if (isset($_SESSION['errorMessage'])) {
    $errorMessage = $_SESSION['errorMessage'];
    unset($_SESSION['errorMessage']);
}

// Handle CSV upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['upload_csv'])) {
    if (isset($_FILES['csv_file']) && $_FILES['csv_file']['error'] === UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['csv_file']['tmp_name'];
        $fileName = $_FILES['csv_file']['name'];
        $fileType = $_FILES['csv_file']['type'];

        $allowedTypes = ['text/csv', 'application/vnd.ms-excel'];
        if (in_array($fileType, $allowedTypes)) {
            if (($handle = fopen($fileTmpPath, 'r')) !== false) {
                // Skip header row
                fgetcsv($handle);
                $pdo->beginTransaction();
                try {
                    while (($data = fgetcsv($handle, 1000, ',')) !== false) {
                        $indexNumber = trim($data[0]);
                        if (!empty($indexNumber)) {
                            $stmt = $pdo->prepare('INSERT INTO valid_index_numbers (index_number) VALUES (:index_number)');
                            $stmt->bindParam(':index_number', $indexNumber);
                            $stmt->execute();
                        }
                    }
                    $pdo->commit();
                    fclose($handle);
                    $_SESSION['successMessage'] = 'CSV file uploaded successfully.';
                } catch (Exception $e) {
                    $pdo->rollBack();
                    $_SESSION['errorMessage'] = 'Error processing CSV file: ' . $e->getMessage();
                }
            } else {
                $_SESSION['errorMessage'] = 'Unable to open the CSV file.';
            }
        } else {
            $_SESSION['errorMessage'] = 'Please upload a valid CSV file.';
        }
    } else {
        $_SESSION['errorMessage'] = 'Please select a CSV file to upload.';
    }
    header('Location: upload_index_numbers.php');
    exit;
}

// Handle manual index number submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_index_number'])) {
    $indexNumber = htmlspecialchars($_POST['index_number'], ENT_QUOTES, 'UTF-8');
    if (!empty($indexNumber)) {
        try {
            $stmt = $pdo->prepare('INSERT INTO valid_index_numbers (index_number) VALUES (:index_number)');
            $stmt->bindParam(':index_number', $indexNumber);
            $stmt->execute();
            $_SESSION['successMessage'] = 'Index number added successfully.';
        } catch (Exception $e) {
            $_SESSION['errorMessage'] = 'Error: ' . $e->getMessage();
        }
    } else {
        $_SESSION['errorMessage'] = 'Index number cannot be empty.';
    }
    header('Location: upload_index_numbers.php');
    exit;
}

// Handle toggle action for Post-Internship functionality
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['toggle_action'])) {
    if ($_POST['toggle_action'] === 'activate') {
        // Update the persistent setting in the database
        $stmt = $pdo->prepare("REPLACE INTO settings (setting_key, setting_value) VALUES (?, ?)");
        $stmt->execute([$settingKey, '1']);
        $_SESSION['successMessage'] = 'Post-Internship functionality activated.';
    } elseif ($_POST['toggle_action'] === 'deactivate') {
        $stmt = $pdo->prepare("REPLACE INTO settings (setting_key, setting_value) VALUES (?, ?)");
        $stmt->execute([$settingKey, '0']);
        $_SESSION['successMessage'] = 'Post-Internship functionality deactivated.';
    }
    header('Location: upload_index_numbers.php');
    exit;
}

// Fetch distinct courses from student_details
$stmt = $pdo->prepare('SELECT DISTINCT `course` FROM student_details');
$stmt->execute();
$courses = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Index Numbers</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
            color: #333;
            font-family: 'Arial', sans-serif;
        }
        .container {
            max-width: 900px;
            margin: 3rem auto;
        }
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }
        .card:hover {
            transform: translateY(-5px);
        }
        .card-header {
            font-size: 1.25rem;
            border-bottom: none;
            background: #f8f9fa;
            text-align: center;
            padding: 1rem 0;
        }
        .btn {
            border-radius: 5px;
        }
        .btn-primary {
            background-color: #0066cc;
            border: none;
        }
        .btn-primary:hover {
            background-color: #0056b3;
        }
        .btn-info {
            background-color: #17a2b8;
            border: none;
        }
        .btn-info:hover {
            background-color: #138496;
        }
        .btn-success {
            background-color: #28a745;
            border: none;
        }
        .btn-success:hover {
            background-color: #218838;
        }
        .btn-warning {
            background-color: #ff9800;
            border: none;
        }
        .btn-warning:hover {
            background-color: #fb8c00;
        }
        .btn-danger {
            background-color: #dc3545;
            border: none;
        }
        .btn-danger:hover {
            background-color: #c82333;
        }
        .form-control {
            border: 1px solid #dee2e6;
            border-radius: 5px;
        }
        .alert {
            border-radius: 5px;
            font-size: 0.9rem;
        }
        .link-style {
            display: block;
            margin-top: 10px;
            color: #007bff;
            text-decoration: none;
            text-align: center;
        }
        .link-style:hover {
            text-decoration: underline;
        }
        h2 {
            font-weight: 600;
            text-align: center;
            margin-bottom: 2rem;
        }
        /* Toggle switch styling */
        .toggle-switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }
        .toggle-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }
        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: 0.4s;
            border-radius: 34px;
        }
        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            transition: 0.4s;
            border-radius: 50%;
        }
        input:checked + .slider {
            background-color: #28a745;
        }
        input:checked + .slider:before {
            transform: translateX(26px);
        }
    </style>
</head>
<body>
<?php include 'admin_header.php'; ?>

<div class="container">
    <h2>Manage Index Numbers & Download Acceptance Letters</h2>

    <?php if (!empty($successMessage)): ?>
        <div class="alert alert-success text-center">
            <?php echo htmlspecialchars($successMessage); ?>
        </div>
    <?php endif; ?>

    <?php if (!empty($errorMessage)): ?>
        <div class="alert alert-danger text-center">
            <?php echo htmlspecialchars($errorMessage); ?>
        </div>
    <?php endif; ?>

    <div class="row g-4">
        <!-- CSV Upload Form -->
        <div class="col-lg-6 col-md-12">
            <div class="card p-3">
                <h4 class="card-header">Upload CSV</h4>
                <div class="card-body">
                    <form method="POST" enctype="multipart/form-data">
                        <div class="mb-3">
                            <input type="file" class="form-control" name="csv_file" id="csv_file" required>
                        </div>
                        <div class="d-grid mb-2">
                            <button type="submit" name="upload_csv" class="btn btn-primary">Upload CSV</button>
                        </div>
                        <a href="download_sample.php" class="link-style">Download Sample CSV</a>
                    </form>
                </div>
            </div>
        </div>

        <!-- Download Acceptance Letters by Course -->
        <div class="col-lg-6 col-md-12">
            <div class="card p-3">
                <h4 class="card-header">Download Acceptance Letters</h4>
                <div class="card-body">
                    <form method="POST" action="download_acceptance_letters.php">
                        <div class="mb-3">
                            <select name="course" class="form-select" required>
                                <option value="">Select Course</option>
                                <?php foreach ($courses as $course): ?>
                                    <option value="<?php echo htmlspecialchars($course['course'], ENT_QUOTES, 'UTF-8'); ?>">
                                        <?php echo htmlspecialchars($course['course'], ENT_QUOTES, 'UTF-8'); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="d-grid">
                            <button type="submit" name="download_acceptance_letters" class="btn btn-info">Download Letters</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Manual Add Form -->
    <div class="row g-4 mt-4">
        <div class="col-lg-6 col-md-12">
            <div class="card p-3">
                <h4 class="card-header">Add Index Number Manually</h4>
                <div class="card-body">
                    <form method="POST">
                        <div class="mb-3">
                            <input type="text" class="form-control" name="index_number" id="index_number" placeholder="Enter index number" required>
                        </div>
                        <div class="d-grid">
                            <button type="submit" name="add_index_number" class="btn btn-success">Add Index Number</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Toggle for Post-Internship Functionality -->
    <div class="row g-4 mt-4">
        <div class="col-lg-6 col-md-12">
            <div class="card p-3">
                <h4 class="card-header">Post-Internship Functionality</h4>
                <div class="card-body text-center">
                    <form method="POST" id="toggleForm">
                        <label class="toggle-switch">
                            <input type="checkbox" name="toggle_post_internship" id="toggle_post_internship"
                                <?php echo ($postInternshipActive) ? 'checked' : ''; ?>>
                            <span class="slider"></span>
                        </label>
                        <!-- Hidden field for action will be appended by JavaScript -->
                    </form>
                    <br>
                    <p id="toggleStatus">
                        <?php 
                        echo ($postInternshipActive)
                            ? "Post-Internship functionality is activated."
                            : "Post-Internship functionality is deactivated.";
                        ?>
                    </p>
                    <br>
                    <?php if ($postInternshipActive): ?>
                        <a href="pi.php" class="btn btn-warning">Go to Post-Internship</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JS and Popper.js -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>

<script>
// Listen for changes on the toggle switch
document.getElementById('toggle_post_internship').addEventListener('change', function() {
    var form = document.getElementById('toggleForm');
    
    // Remove any existing hidden input if present
    var existing = document.querySelector('input[name="toggle_action"]');
    if (existing) {
        existing.parentNode.removeChild(existing);
    }
    
    // Create a new hidden input with the proper value based on toggle state
    var hiddenInput = document.createElement('input');
    hiddenInput.type = 'hidden';
    hiddenInput.name = 'toggle_action';
    hiddenInput.value = this.checked ? 'activate' : 'deactivate';
    form.appendChild(hiddenInput);
    
    // Optionally update the status text immediately (will be updated on page reload as well)
    document.getElementById('toggleStatus').innerText = this.checked 
        ? "Post-Internship functionality is activated." 
        : "Post-Internship functionality is deactivated.";
    
    // Submit the form automatically on toggle change
    form.submit();
});
</script>

</body>
</html>
