<?php
session_start();
if(!isset($_SESSION['lecturer_id'])){
  header('Location: login.php');
  exit;
}

require '../config/database.php';

$myLecturerId = $_SESSION['lecturer_id'];

// Fetch my details (with region if needed)
$sql = "
  SELECT l.id, l.name, p.preferred_region
  FROM lecturer_login l
  JOIN lecturer_preferences p ON l.id = p.lecturer_id
  WHERE l.id = ?
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$myLecturerId]);
$me = $stmt->fetch(PDO::FETCH_ASSOC);
if(!$me){
  $_SESSION['error'] = "Lecturer not found or preferences missing.";
  header('Location: login.php');
  exit;
}

// Fetch pending requests for me
$sql = "
  SELECT sr.*,
         lr.name AS requesting_lecturer_name,
         sd.first_name AS req_st_fname,
         sd.surname    AS req_st_sname,
         u.index_number AS req_st_index
  FROM swap_requests sr
  JOIN lecturer_login lr ON sr.requesting_lecturer_id = lr.id
  JOIN student_details sd ON sr.requesting_student_id = sd.id
  JOIN users u ON sd.user_id = u.id
  WHERE sr.requested_lecturer_id = ?
    AND sr.status = 'pending'
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$myLecturerId]);
$requests = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch my assigned students
$sql = "
  SELECT sd.id, sd.first_name, sd.surname, u.index_number
  FROM student_details sd
  JOIN users u ON sd.user_id = u.id
  WHERE sd.lecturer_id = ?
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$myLecturerId]);
$myStudents = $stmt->fetchAll(PDO::FETCH_ASSOC);

$swapError   = $_SESSION['error']   ?? '';
$swapSuccess = $_SESSION['success'] ?? '';
unset($_SESSION['error'], $_SESSION['success']);
?>
<!doctype html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Incoming Swap Requests</title>
  <link rel="stylesheet" 
    href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
<div class="container my-4">
  <h2>Swap Requests for <?php echo htmlspecialchars($me['name']); ?></h2>

  <?php if($swapError): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($swapError); ?></div>
  <?php endif; ?>
  <?php if($swapSuccess): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($swapSuccess); ?></div>
  <?php endif; ?>

  <?php if(empty($requests)): ?>
    <div class="alert alert-info">No pending requests.</div>
  <?php else: ?>
    <?php foreach($requests as $req): ?>
      <div class="card mb-3">
        <div class="card-body">
          <h5 class="card-title">
            Request from: <?php echo htmlspecialchars($req['requesting_lecturer_name']); ?>
          </h5>
          <p>
            They want to swap their student:
            <strong><?php echo htmlspecialchars($req['req_st_fname'].' '.$req['req_st_sname']); ?></strong>
            (Index: <?php echo htmlspecialchars($req['req_st_index']); ?>)
          </p>
          <form action="process_swap_decision.php" method="POST" class="row g-2">
            <input type="hidden" name="swap_request_id" value="<?php echo $req['id']; ?>">

            <div class="col-auto">
              <label for="my_student_id_<?php echo $req['id']; ?>" class="form-label">
                My Student
              </label>
              <select name="my_student_id" id="my_student_id_<?php echo $req['id']; ?>"
                      class="form-select" required>
                <option value="">-- Select Student --</option>
                <?php foreach($myStudents as $ms): ?>
                  <option value="<?php echo $ms['id']; ?>">
                    <?php echo htmlspecialchars($ms['first_name'].' '.$ms['surname'].' ('.$ms['index_number'].')'); ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-auto mt-4">
              <button type="submit" name="decision" value="accept" class="btn btn-success">
                Accept &amp; Swap
              </button>
              <button type="submit" name="decision" value="decline" class="btn btn-danger">
                Decline
              </button>
            </div>
          </form>
        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
