<?php
session_start();
header('Content-Type: application/json');
if (!isset($_SESSION['lecturer_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not logged in']);
    exit;
}
require '../config/database.php';
$lecturer_id = $_SESSION['lecturer_id'];

// Collect and validate POST data
$student_id = intval($_POST['student_id'] ?? 0);
$appearance = intval($_POST['appearance'] ?? 0);
$organisation = intval($_POST['organisation'] ?? 0);
$cv = intval($_POST['cv'] ?? 0);
$technical_practical = intval($_POST['technical_practical'] ?? 0);
$reflects_practical = intval($_POST['reflects_practical'] ?? 0);
$demeanor = intval($_POST['demeanor'] ?? 0);
$communication = intval($_POST['communication'] ?? 0);
$eye_contact = intval($_POST['eye_contact'] ?? 0);
$question_answer = intval($_POST['question_answer'] ?? 0);
$philosophy = intval($_POST['philosophy'] ?? 0);
$comments = trim($_POST['comments'] ?? '');

// Calculate subtotals and total
$ppt_total = $appearance + $organisation + $cv + $technical_practical + $reflects_practical;
$pres_total = $demeanor + $communication + $eye_contact + $question_answer + $philosophy;
$total_score = $ppt_total + $pres_total;
if ($ppt_total > 50 || $pres_total > 50 || $total_score > 100) {
    echo json_encode(['success' => false, 'message' => 'Section or total exceeds maximum allowed.']);
    exit;
}

// Insert or update grade
try {
    $stmt = $pdo->prepare("SELECT id FROM teaching_grades WHERE student_id = ? AND lecturer_id = ?");
    $stmt->execute([$student_id, $lecturer_id]);
    $existing = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($existing) {
        // Update
        $stmt = $pdo->prepare("UPDATE teaching_grades SET appearance=?, organisation=?, cv=?, technical_practical=?, reflects_practical=?, demeanor=?, communication=?, eye_contact=?, question_answer=?, philosophy=?, ppt_total=?, pres_total=?, total_score=?, comments=?, graded_at=NOW() WHERE id=?");
        $stmt->execute([$appearance, $organisation, $cv, $technical_practical, $reflects_practical, $demeanor, $communication, $eye_contact, $question_answer, $philosophy, $ppt_total, $pres_total, $total_score, $comments, $existing['id']]);
    } else {
        // Insert
        $stmt = $pdo->prepare("INSERT INTO teaching_grades (student_id, lecturer_id, appearance, organisation, cv, technical_practical, reflects_practical, demeanor, communication, eye_contact, question_answer, philosophy, ppt_total, pres_total, total_score, comments, graded_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");
        $stmt->execute([$student_id, $lecturer_id, $appearance, $organisation, $cv, $technical_practical, $reflects_practical, $demeanor, $communication, $eye_contact, $question_answer, $philosophy, $ppt_total, $pres_total, $total_score, $comments]);
    }
    echo json_encode(['success' => true, 'message' => 'Grade submitted successfully.']);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
} 