<!-- speed-dial.php -->
<div class="fab-container" 
     id="fabContainer" 
     style="top: calc(100vh - 140px); left: calc(100vw - 80px);">
  <!-- Main Floating Button -->
  <button class="fab-button" id="piFloatingButton">
    <span class="fab-text">PI</span>
    <span class="notification-dot"></span>
  </button>
  
  <!-- Expanding Speed Dial Menu -->
  <ul class="fab-menu" id="piFloatingMenu">
    <li>
      <button class="fab-item" id="piTeamBtn">
        <span>PI Team</span>
        <i class="bi bi-people" style="font-size: 1.2rem; margin-left: 8px;"></i>
      </button>
    </li>
    <li>
      <button class="fab-item" id="piSupervisionBtn">
        <span>PI Supervision</span>
        <i class="bi bi-person-check" style="font-size: 1.2rem; margin-left: 8px;"></i>
      </button>
    </li>
  </ul>
</div>

<script>
// Wait for the DOM to load
document.addEventListener('DOMContentLoaded', function() {
  const fabContainer = document.getElementById('fabContainer');
  const mainFab = document.getElementById('piFloatingButton');
  const fabMenu = document.getElementById('piFloatingMenu');
  
  let piMenuVisible = false;
  let isDragging = false;
  let startX = 0, startY = 0;
  let offsetX = 0, offsetY = 0;

  // === 1) Speed Dial Toggle ===
  mainFab.addEventListener('click', function(e) {
    // If we are in the middle of dragging, ignore the click
    if (isDragging) return;
    
    e.preventDefault();
    piMenuVisible = !piMenuVisible;
    fabMenu.classList.toggle('show');
    // Optional rotation animation
    mainFab.classList.toggle('rotate');
  });

  // === 2) "PI Team" Button ===
  document.getElementById('piTeamBtn').addEventListener('click', function() {
    fabMenu.classList.remove('show');
    mainFab.classList.remove('rotate');
    document.getElementById('piTeamContent').innerHTML = '<p class="text-center">Loading PI Team details...</p>';
    const piTeamModal = new bootstrap.Modal(document.getElementById('piTeamModal'));
    piTeamModal.show();
    
    fetch('colleague_lecturers.php')
      .then(response => response.text())
      .then(data => {
        document.getElementById('piTeamContent').innerHTML = data;
      })
      .catch(error => {
        document.getElementById('piTeamContent').innerHTML = '<p class="text-danger text-center">Failed to load PI Team details.</p>';
        console.error('Error fetching PI Team details:', error);
      });
  });

  // === 3) "PI Supervision" Button ===
  document.getElementById('piSupervisionBtn').addEventListener('click', function() {
    fabMenu.classList.remove('show');
    mainFab.classList.remove('rotate');
    window.location.href = 'lecturer_dashboard';
  });

  // === 4) Draggable Logic ===
  // MOUSE:
  fabContainer.addEventListener('mousedown', (e) => {
    // Only start dragging if user clicks on the container or mainFab
    // (not on the menu items).
    if (e.target !== fabContainer && e.target !== mainFab) return;
    
    isDragging = true;
    startX = e.clientX;
    startY = e.clientY;
    const rect = fabContainer.getBoundingClientRect();
    offsetX = startX - rect.left;
    offsetY = startY - rect.top;
  });

  document.addEventListener('mousemove', (e) => {
    if (!isDragging) return;
    e.preventDefault();
    const newX = e.clientX - offsetX;
    const newY = e.clientY - offsetY;
    fabContainer.style.left = newX + 'px';
    fabContainer.style.top = newY + 'px';
  });

  document.addEventListener('mouseup', () => {
    isDragging = false;
  });

  // TOUCH:
  fabContainer.addEventListener('touchstart', (e) => {
    if (e.touches.length === 1) {
      isDragging = true;
      const touch = e.touches[0];
      startX = touch.clientX;
      startY = touch.clientY;
      const rect = fabContainer.getBoundingClientRect();
      offsetX = startX - rect.left;
      offsetY = startY - rect.top;
    }
  });

  document.addEventListener('touchmove', (e) => {
    if (!isDragging || e.touches.length !== 1) return;
    const touch = e.touches[0];
    const newX = touch.clientX - offsetX;
    const newY = touch.clientY - offsetY;
    fabContainer.style.left = newX + 'px';
    fabContainer.style.top = newY + 'px';
  });

  document.addEventListener('touchend', () => {
    isDragging = false;
  });
});
</script>

<style>
/* 
  We use 'top' and 'left' so we can drag the button around.
  The inline style in the <div> sets it near the bottom-right 
  using calc(100vh - 140px) and calc(100vw - 80px).
*/
.fab-container {
  position: fixed;
  width: 60px;
  height: 60px;
  z-index: 9999;
}

/* Main Floating Button: square with rounded corners */
.fab-button {
  position: relative;
  width: 100%;
  height: 100%;
  border: none;
  border-radius: 14px;
  background-color: #0d2e4a;
  color: #ffffff;
  cursor: pointer;
  box-shadow: 0 8px 20px rgba(0,0,0,0.4);
  outline: none;
  transition: transform 0.3s ease-in-out;
}

/* If you want the rotate effect on open */
.fab-button.rotate {
  transform: rotate(45deg);
}

/* "PI" text in the center */
.fab-text {
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  font-size: 1.0rem;
  font-weight: 600;
}

/* Small orange notification dot in top-right corner */
.notification-dot {
  position: absolute;
  top: 6px;
  right: 6px;
  width: 10px;
  height: 10px;
  background-color: #ff9500;
  border-radius: 50%;
}

/* Speed Dial Menu (unchanged) */
.fab-menu {
  list-style: none;
  margin: 0;
  padding: 0;
  position: absolute;
  bottom: 70px; /* Appear above the main button */
  right: 0;
  opacity: 0;
  transform: scale(0);
  transform-origin: bottom right;
  transition: transform 0.3s ease-in-out, opacity 0.2s ease-in-out;
}

.fab-menu.show {
  opacity: 1;
  transform: scale(1);
}

.fab-menu li {
  margin-bottom: 8px;
}

/* Mini "chip" items */
.fab-item {
  display: flex;
  align-items: center;
  justify-content: space-between;
  background: #fff;
  color: #333;
  border: none;
  border-radius: 24px;
  padding: 6px 12px;
  box-shadow: 0 2px 6px rgba(0,0,0,0.2);
  cursor: pointer;
  transition: background 0.2s ease-in-out;
  font-size: 0.95rem;
  min-width: 120px;
}

.fab-item:hover {
  background: #f5f5f5;
}
</style>
