<?php
session_start();
if (!isset($_SESSION['lecturer_id'])) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

include '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $lecturerId = $_SESSION['lecturer_id'];
    $data = json_decode(file_get_contents('php://input'), true);

    // Ensure the data is sanitized properly for URL encoding
    $message = urlencode($data['message']);
    $students = array_map('urlencode', $data['students']);

    $apiKey = 'igaYAqbJLFh1JGSBOrGeYQBUa';
    $senderId = 'SoB-UEW';

    foreach ($students as $telephone) {
        $url = "https://apps.mnotify.net/smsapi?key=$apiKey&to=$telephone&msg=$message&sender_id=$senderId";
        $response = file_get_contents($url);
        // Optionally, you can handle the response and error codes here
    }

    // After sending SMS, update the database to mark SMS as sent
    $stmt = $pdo->prepare('UPDATE lecturer_login SET sms_sent = 1 WHERE id = ?');
    $stmt->execute([$lecturerId]);

    echo json_encode(['status' => 'success', 'message' => 'Bulk SMS sent successfully!']);
} else {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
}
?>
