<?php
session_start();
// If you want only admin to see this:
// if (!isset($_SESSION['admin_id'])) {
//     header('Location: login.php');
//     exit;
// }

include '../config/database.php';

// 1. Fetch "allocations" or "routes" (region/district + student count)
$query = "
    SELECT region,
           district,
           COUNT(*) AS total_students
      FROM student_details
      WHERE status = 'submitted'  -- (optional filter)
      GROUP BY region, district
      ORDER BY region, district
";
$stmt = $pdo->prepare($query);
$stmt->execute();
$allocations = $stmt->fetchAll(PDO::FETCH_ASSOC);

// 2. Prepare a naive “best route” by simply listing region/district in alphabetical order
//    If you had real distances, you'd compute an optimal path or a TSP. 
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Supervision Route Allocation</title>
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    /* Optional chat-like styles */
    .chat-container {
      max-width: 700px;
      margin: 0 auto;
      display: flex;
      flex-direction: column;
      gap: 1rem;
    }
    .chat-bubble {
      padding: 1rem;
      border-radius: 15px;
      color: #fff;
      width: fit-content;
      max-width: 80%;
    }
    .bubble-admin {
      align-self: flex-start;
      background-color: #0d6efd; /* Bootstrap primary color */
    }
    .bubble-location {
      align-self: flex-end;
      background-color: #198754; /* Bootstrap success color */
    }
    .bubble-header {
      font-weight: bold;
      margin-bottom: 0.3rem;
    }
    .bubble-footer {
      font-size: 0.85rem;
      margin-top: 0.3rem;
      opacity: 0.8;
    }
  </style>
</head>
<body class="bg-light">

<div class="container py-4">
  <h1 class="mb-4 text-center">Simple Supervision Route Allocation (Chat Style)</h1>

  <?php if (!empty($allocations)): ?>
    <div class="chat-container">
      
      <!-- Example: A quick admin "intro" bubble -->
      <div class="chat-bubble bubble-admin">
        <div class="bubble-header">System</div>
        Hello! Here is the proposed supervision route for your visits. 
        <div class="bubble-footer">Click on any row for details. (Just an example UI)</div>
      </div>

      <?php foreach ($allocations as $index => $row): ?>
        <?php
          $region = htmlspecialchars($row['region'], ENT_QUOTES, 'UTF-8');
          $district = htmlspecialchars($row['district'], ENT_QUOTES, 'UTF-8');
          $count = (int) $row['total_students'];
        ?>
        <!-- Each location becomes a new bubble -->
        <div class="chat-bubble bubble-location">
          <div class="bubble-header">
            <?php echo "Stop #".($index + 1); ?>
          </div>
          Region: <strong><?php echo $region; ?></strong><br>
          District: <strong><?php echo $district; ?></strong><br>
          Students: <strong><?php echo $count; ?></strong>
          <div class="bubble-footer">
            Scheduled supervision route
          </div>
        </div>
      <?php endforeach; ?>

      <!-- Example: Another "admin" type bubble at the end -->
      <div class="chat-bubble bubble-admin">
        <div class="bubble-header">System</div>
        That’s all! Good luck with your supervisions.
        <div class="bubble-footer">End of Route</div>
      </div>

    </div>
  <?php else: ?>
    <p class="text-muted">No allocations found.</p>
  <?php endif; ?>
</div>

<!-- Bootstrap 5 JS (includes Popper) -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>
</body>
</html>
