<?php
session_start();
include '../config/database.php';

if (!isset($_SESSION['allow_password_reset']) || !$_SESSION['allow_password_reset'] || !isset($_SESSION['reset_user_id'])) {
    header('Location: forgot_password.php');
    exit;
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_password = $_POST['new_password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';
    if (strlen($new_password) < 6) {
        $error = 'Password must be at least 6 characters.';
    } elseif ($new_password !== $confirm_password) {
        $error = 'Passwords do not match.';
    } else {
        $hashed = password_hash($new_password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare('UPDATE lecturer_login SET password = ? WHERE id = ?');
        $stmt->execute([$hashed, $_SESSION['reset_user_id']]);
        // Clear session reset vars
        unset($_SESSION['allow_password_reset'], $_SESSION['reset_user_id'], $_SESSION['reset_username'], $_SESSION['reset_phone'], $_SESSION['reset_expected_digits'], $_SESSION['reset_masked_phone']);
        $success = 'Password reset successful! <a href="login.php">Click here to login</a>.';
    }
}

include 'lect_header.php';
?>

<div class="container d-flex justify-content-center align-items-center" style="min-height: 100vh;">
    <div class="card p-4" style="max-width: 400px; width: 100%;">
        <h2 class="card-title text-center">Reset Password</h2>
        <?php if ($error): ?>
            <div class="alert alert-danger text-center"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        <?php if ($success): ?>
            <div class="alert alert-success text-center"><?php echo $success; ?></div>
        <?php else: ?>
        <form method="POST" action="">
            <div class="mb-3">
                <label for="new_password" class="form-label">New Password</label>
                <input type="password" class="form-control" id="new_password" name="new_password" required minlength="6">
            </div>
            <div class="mb-3">
                <label for="confirm_password" class="form-label">Confirm Password</label>
                <input type="password" class="form-control" id="confirm_password" name="confirm_password" required minlength="6">
            </div>
            <button type="submit" class="btn btn-primary w-100">Reset Password</button>
        </form>
        <?php endif; ?>
        <div class="mt-3 text-center">
            <a href="login.php" class="small">Back to Login</a>
        </div>
    </div>
</div>

<?php include 'lect_footer.php'; ?>
