<?php
// If no students, no reason to create modals
if (!isset($students) || empty($students)) {
    return;
}

// Define the report assessment categories and their corresponding criteria
$reportCategories = [
    'Content Quality' => [
        [ 'label' => 'Executive Summary Quality', 'max' => 10, 'field' => 'executive_summary_quality' ],
        [ 'label' => 'Introduction and Background', 'max' => 10, 'field' => 'introduction_quality' ],
        [ 'label' => 'Institution Profile Completeness', 'max' => 8, 'field' => 'institution_profile_quality' ],
        [ 'label' => 'Goals and Objectives Clarity', 'max' => 8, 'field' => 'goals_objectives_quality' ],
        [ 'label' => 'Core Duties Description', 'max' => 12, 'field' => 'core_duties_quality' ],
        [ 'label' => 'Challenges Analysis', 'max' => 10, 'field' => 'challenges_analysis' ],
        [ 'label' => 'Achievements Documentation', 'max' => 15, 'field' => 'achievements_documentation' ],
        [ 'label' => 'Lessons Learned Reflection', 'max' => 10, 'field' => 'lessons_learned_quality' ],
        [ 'label' => 'Recommendations Quality', 'max' => 8, 'field' => 'recommendations_quality' ],
        [ 'label' => 'Conclusion and References', 'max' => 9, 'field' => 'conclusion_references' ],
    ],
];

foreach ($students as $student):

    // Query the existing report grade for this lecturer & student
    $stmt = $pdo->prepare("
        SELECT *
        FROM pi_student_grades
        WHERE student_id = :student_id
          AND lecturer_id = :lecturer_id
          AND report_score IS NOT NULL
        ORDER BY graded_at DESC
        LIMIT 1
    ");
    $stmt->execute([
        'student_id'  => $student['student_id'],
        'lecturer_id' => $lecturer_id
    ]);
    $existing_scores = $stmt->fetch(PDO::FETCH_ASSOC);

    // Extract the full name from student_details
    $fullName = trim(
        ($student['first_name'] ?? '') . ' ' . 
        ($student['other_names'] ?? '') . ' ' . 
        ($student['surname'] ?? '')
    );
?>

<div class="modal fade"
     id="reportGradeModal<?php echo $student['student_id']; ?>"
     tabindex="-1"
     aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content shadow-lg border-0" style="border-top: 5px solid #0d6efd;">

      <div class="modal-header" style="background: linear-gradient(90deg, #0d6efd 80%, #2563eb 100%); color: #fff;">
        <h5 class="modal-title fw-bold">
          <i class="fas fa-file-alt me-2"></i>Report Assessment - <?php echo htmlspecialchars($fullName); ?>
        </h5>
        <button type="button" class="btn-close btn-close-white"
                data-bs-dismiss="modal"
                aria-label="Close"></button>
      </div>

      <div class="modal-body px-4 py-4 rounded-bottom" style="background: #f4f8fd;">
        <!-- The form submits to submit_report_grade.php -->
        <form method="POST" action="submit_report_grade.php" id="reportGradingForm">
          <!-- Hidden student_id -->
          <input type="hidden"
                 name="student_id"
                 value="<?php echo $student['student_id']; ?>" />

          <div class="alert mb-4 shadow-sm" style="background: #e3f0ff; border-left: 5px solid #0d6efd; color: #0d2956;">
            <strong>Report Assessment (50% of total grade)</strong><br>
            Grade the student's internship report based on the criteria below.<br>
            <span class="text-muted small">The total possible score is <b>100 points</b>.</span>
          </div>

          <div class="table-responsive mb-4">
            <table class="table table-bordered table-hover align-middle mb-0" style="border-color: #0d6efd;">
              <thead style="background: #0d6efd; color: #fff;">
                <tr>
                  <th style="width:40%">Category / Criteria</th>
                  <th style="width:15%">Max Marks</th>
                  <th style="width:20%">Score</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($reportCategories as $categoryName => $criteriaArray): ?>
                  <?php $firstRow = true; ?>
                  <?php foreach ($criteriaArray as $item):
                          $field = $item['field'];
                          $max   = $item['max'];
                          $label = $item['label'];

                          // Display the category name only on the first row of each group
                          if ($firstRow) {
                              $categoryCellContent = "<strong>{$categoryName}</strong><br><span class='text-muted small'>{$label}</span>";
                              $firstRow = false;
                          } else {
                              $categoryCellContent = "<span class='text-muted small'>{$label}</span>";
                          }
                  ?>
                  <tr>
                    <td><?php echo $categoryCellContent; ?></td>
                    <td class="text-center fw-bold text-primary" style="background: #e3f0ff;"><?php echo $max; ?></td>
                    <td>
                      <input
                        type="number"
                        name="<?php echo $field; ?>"
                        class="form-control report-score text-center fw-semibold border-primary"
                        min="0"
                        max="<?php echo $max; ?>"
                        value="<?php echo $existing_scores[$field] ?? ''; ?>"
                        required
                        onchange="calculateReportTotal()"
                        style="max-width: 90px; margin: 0 auto; border-width: 2px;"
                      />
                    </td>
                  </tr>
                  <?php endforeach; ?>
                <?php endforeach; ?>
                <tr style="background: linear-gradient(90deg, #0d6efd 80%, #2563eb 100%); color: #fff;">
                  <td class="fw-bold text-end">Total Report Score</td>
                  <td class="fw-bold text-center">100</td>
                  <td>
                    <input type="number" 
                           id="reportTotal<?php echo $student['student_id']; ?>" 
                           name="report_total" 
                           class="form-control bg-white text-center fw-bold border-0" 
                           readonly 
                           value="<?php echo $existing_scores['report_score'] ?? ''; ?>"
                           style="font-size:1.2rem; max-width: 110px; margin: 0 auto; background: #e3f0ff; color: #0d2956; border-radius: 6px;"
                    />
                  </td>
                </tr>
              </tbody>
            </table>
          </div>

          <!-- Comments Section -->
          <div class="mb-3">
            <label class="form-label fw-semibold"><i class="fas fa-comment-dots me-1 text-primary"></i>Comments on Report <span class="text-muted small">(Optional)</span></label>
            <textarea
              name="report_comments"
              class="form-control shadow-sm border-primary"
              rows="3"
              placeholder="Add your comments here..."
              style="border-width: 2px;"
            ><?php echo htmlspecialchars_decode($existing_scores['report_comments'] ?? ''); ?></textarea>
          </div>

          <!-- Submit Button and Status -->
          <button type="submit" name="grade_report" class="btn btn-primary w-100 mt-2 py-2 fs-5 shadow" id="reportGradeSubmitBtn<?php echo $student['student_id']; ?>">
            <i class="fas fa-save me-2"></i>Update Grade
          </button>
          <div id="reportGradeStatus<?php echo $student['student_id']; ?>" class="mt-2"></div>
        </form>
      </div>

    </div>
  </div>
</div>

<script>
function calculateReportTotal() {
    const studentId = <?php echo $student['student_id']; ?>;
    const scoreInputs = document.querySelectorAll('#reportGradeModal' + studentId + ' .report-score');
    let total = 0;
    scoreInputs.forEach(input => {
        const value = parseInt(input.value) || 0;
        total += value;
    });
    document.getElementById('reportTotal' + studentId).value = total;
}

document.addEventListener('DOMContentLoaded', function() {
    calculateReportTotal();
    // AJAX form submission for confirmation and button text update
    document.querySelectorAll('[id^="reportGradingForm"]').forEach(function(form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            const studentId = form.querySelector('input[name="student_id"]').value;
            const statusDiv = document.getElementById('reportGradeStatus' + studentId);
            const submitBtn = document.getElementById('reportGradeSubmitBtn' + studentId);
            statusDiv.textContent = 'Submitting...';
            statusDiv.className = 'mt-2 text-info';
            const formData = new FormData(form);
            fetch('submit_report_grade.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    statusDiv.textContent = 'Grade updated successfully!';
                    statusDiv.className = 'mt-2 text-success';
                    submitBtn.innerHTML = '<i class="fas fa-save me-2"></i>Update Grade';
                    setTimeout(function() {
                        window.location.reload();
                    }, 1000);
                } else {
                    statusDiv.textContent = 'Error: ' + data.message;
                    statusDiv.className = 'mt-2 text-danger';
                }
            })
            .catch(error => {
                statusDiv.textContent = 'An error occurred. Please try again.';
                statusDiv.className = 'mt-2 text-danger';
            });
        });
    });
});
</script>

<?php endforeach; ?> 