<?php
// process_request_swap.php
session_start();
if (!isset($_SESSION['lecturer_id'])) {
    header('Location: login.php');
    exit;
}
require '../config/database.php';

$myLecturerId        = $_SESSION['lecturer_id'];
$myStudentId         = $_POST['my_student_id'] ?? null;
$colleagueLecturerId = $_POST['colleague_lecturer_id'] ?? null;

if (!$myStudentId || !$colleagueLecturerId) {
    $_SESSION['error'] = "Please select your student and a colleague.";
    header('Location: index.php');
    exit;
}

// Verify the selected student belongs to the logged-in lecturer
$stmt = $pdo->prepare("SELECT lecturer_id FROM student_details WHERE id = ?");
$stmt->execute([$myStudentId]);
$lectIdCheck = $stmt->fetchColumn();

if ($lectIdCheck != $myLecturerId) {
    $_SESSION['error'] = "The selected student is not assigned to you.";
    header('Location: index.php');
    exit;
}

// Insert a pending swap request
$sql = "
  INSERT INTO swap_requests (
    requesting_lecturer_id,
    requested_lecturer_id,
    requesting_student_id,
    status
  ) VALUES (?, ?, ?, 'pending')
";
$stmt = $pdo->prepare($sql);
$stmt->execute([
    $myLecturerId,
    $colleagueLecturerId,
    $myStudentId
]);

$_SESSION['success'] = "Swap request sent successfully.";
header('Location: index.php');
exit;
?>
