<?php
// process_assignment.php

include '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 1) Grab the submitted assignments array
    $assignments = isset($_POST['lecturer_assignment']) ? $_POST['lecturer_assignment'] : [];

    // 2) Prepare the UPDATE query
    $updateQuery = 'UPDATE student_details
                    SET lecturer_id = :lecturer_id
                    WHERE id = :student_id';
    $stmt = $pdo->prepare($updateQuery);

    // 3) Loop through each student => lecturer_id pair
    foreach ($assignments as $studentId => $lecturerId) {
        if (empty($lecturerId)) {
            continue; // Skip if no lecturer chosen
        }
        // Bind and execute
        $stmt->bindParam(':lecturer_id', $lecturerId, PDO::PARAM_INT);
        $stmt->bindParam(':student_id', $studentId, PDO::PARAM_INT);
        $stmt->execute();
    }

    // Preserve the filters
    $regionFilter       = isset($_POST['region_filter']) ? $_POST['region_filter'] : '';
    $districtFilter     = isset($_POST['district_filter']) ? $_POST['district_filter'] : '';
    $groupFilter        = isset($_POST['group_filter']) ? $_POST['group_filter'] : '';
    $groupIndustrial    = isset($_POST['group_filter_industrial']) ? $_POST['group_filter_industrial'] : '';
    $unassignedFilter   = isset($_POST['unassigned_filter']) ? $_POST['unassigned_filter'] : '';
    $sortByOrganisation = isset($_POST['sort_by_organisation']) ? $_POST['sort_by_organisation'] : '';

    // Build redirect
    $redirectUrl = 'assign_students.php?assignment=success'
                 . '&region_filter=' . urlencode($regionFilter)
                 . '&district_filter=' . urlencode($districtFilter)
                 . '&group_filter=' . urlencode($groupFilter)
                 . '&group_filter_industrial=' . urlencode($groupIndustrial)
                 . '&unassigned_filter=' . urlencode($unassignedFilter);

    if ($sortByOrganisation === 'true') {
        $redirectUrl .= '&sort_by_organisation=true';
    }

    header('Location: ' . $redirectUrl);
    exit;
} else {
    header('Location: assign_students.php');
    exit;
}
