<?php
// If no students, no reason to create modals
if (!isset($students) || empty($students)) {
    return;
}

// Define the presentation assessment categories and their corresponding criteria
$presentationCategories = [
    'Scoring' => [
        [ 'label' => 'Contents', 'max' => 20, 'field' => 'contents' ],
        [ 'label' => 'Coherence', 'max' => 5, 'field' => 'coherence' ],
        [ 'label' => 'Presentation Etiquette', 'max' => 10, 'field' => 'presentation_etiquette' ],
        [ 'label' => 'Ability to Answer Questions', 'max' => 10, 'field' => 'ability_to_answer_questions' ],
        [ 'label' => 'Time Awareness', 'max' => 5, 'field' => 'time_awareness' ],
    ],
];

foreach ($students as $student):

    // Query the existing presentation grade for this lecturer & student
    $stmt = $pdo->prepare("
        SELECT *
        FROM pi_student_grades
        WHERE student_id = :student_id
          AND lecturer_id = :lecturer_id
          AND presentation_score IS NOT NULL
        ORDER BY graded_at DESC
        LIMIT 1
    ");
    $stmt->execute([
        'student_id'  => $student['student_id'],
        'lecturer_id' => $lecturer_id
    ]);
    $existing_scores = $stmt->fetch(PDO::FETCH_ASSOC);

    // Extract the full name from student_details
    $fullName = trim(
        ($student['first_name'] ?? '') . ' ' . 
        ($student['other_names'] ?? '') . ' ' . 
        ($student['surname'] ?? '')
    );
?>

<div class="modal fade"
     id="presentationGradeModal<?php echo $student['student_id']; ?>"
     tabindex="-1"
     aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-fullscreen-sm-down">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">
          Presentation Assessment - <?php echo htmlspecialchars($fullName); ?>
        </h5>
        <button type="button" class="btn-close"
                data-bs-dismiss="modal"
                aria-label="Close"></button>
      </div>

      <div class="modal-body">
        <!-- The form submits to submit_presentation_grade.php -->
        <form method="POST" action="submit_presentation_grade.php" id="presentationGradingForm">
          <!-- Hidden student_id -->
          <input type="hidden"
                 name="student_id"
                 value="<?php echo $student['student_id']; ?>" />

          <div class="alert alert-success">
            <strong>Presentation Assessment (50% of final grade)</strong><br>
            Grade the student's presentation out of <b>50%</b> (maximum 50 points). This score will be combined with the report score for the final grade.
          </div>

          <div class="table-responsive">
            <table class="table table-bordered">
              <thead class="table-light">
                <tr>
                  <th>Evaluation Criteria</th>
                  <th>Max Marks</th>
                  <th>Score</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($presentationCategories as $categoryName => $criteriaArray): ?>
                  <?php $firstRow = true; ?>
                  <?php foreach ($criteriaArray as $item):
                          $field = $item['field'];
                          $max   = $item['max'];
                          $label = $item['label'];

                          // Display the category name only on the first row of each group
                          if ($firstRow) {
                              $categoryCellContent = "<strong>{$categoryName}</strong><br>{$label}";
                              $firstRow = false;
                          } else {
                              $categoryCellContent = $label;
                          }
                  ?>
                  <tr>
                    <td><?php echo $categoryCellContent; ?></td>
                    <td><?php echo $max; ?></td>
                    <td>
                      <input
                        type="number"
                        name="<?php echo $field; ?>"
                        class="form-control presentation-score"
                        min="0"
                        max="<?php echo $max; ?>"
                        value="<?php echo $existing_scores[$field] ?? ''; ?>"
                        required
                        onchange="calculatePresentationTotal(<?php echo $student['student_id']; ?>)"
                      />
                    </td>
                  </tr>
                  <?php endforeach; ?>
                <?php endforeach; ?>
                <tr class="table-success">
                  <td><strong>Total Presentation Score (out of 50%)</strong></td>
                  <td><strong>50</strong></td>
                  <td>
                    <input type="number" 
                           id="presentationTotal<?php echo $student['student_id']; ?>" 
                           name="presentation_total" 
                           class="form-control bg-light" 
                           readonly 
                           max="50"
                           value="<?php echo $existing_scores['presentation_score'] ?? ''; ?>"
                    />
                    <span id="presentationTotalWarning<?php echo $student['student_id']; ?>" class="text-danger small" style="display:none;">Total cannot exceed 50.</span>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>

          <!-- Comments Section -->
          <div class="mb-3">
            <label class="form-label"><strong>Comments on Presentation (Optional)</strong></label>
            <textarea
              name="presentation_comments"
              class="form-control"
              rows="3"
            ><?php echo $existing_scores['presentation_comments'] ?? ''; ?></textarea>
          </div>

          <!-- Submit Button -->
          <button type="submit" name="grade_presentation" class="btn btn-success w-100 mt-2">
            <?php echo ($existing_scores) ? "Update Presentation Grade" : "Submit Presentation Grade"; ?>
          </button>
          <span id="presentationGradeStatus<?php echo $student['student_id']; ?>" class="mt-2 d-block"></span>
        </form>
      </div>

    </div>
  </div>
</div>

<style>
#presentationGradeModal<?php echo $student['student_id']; ?> .modal-header .btn-close {
    filter: invert(1) grayscale(1) brightness(2);
}
</style>

<script>
function calculatePresentationTotal(studentId) {
    const scoreInputs = document.querySelectorAll('#presentationGradeModal' + studentId + ' .presentation-score');
    let total = 0;
    scoreInputs.forEach(input => {
        const value = parseInt(input.value) || 0;
        total += value;
    });
    const totalInput = document.getElementById('presentationTotal' + studentId);
    const warning = document.getElementById('presentationTotalWarning' + studentId);
    const submitBtn = document.querySelector('#presentationGradeModal' + studentId + ' button[type="submit"]');
    if (total > 50) {
        totalInput.value = 50;
        warning.style.display = '';
        if (submitBtn) submitBtn.disabled = true;
    } else {
        totalInput.value = total;
        warning.style.display = 'none';
        if (submitBtn) submitBtn.disabled = false;
    }
}

// Attach event listeners to all presentation modals
window.addEventListener('DOMContentLoaded', function() {
    <?php foreach ($students as $student): ?>
    (function() {
        const studentId = <?php echo $student['student_id']; ?>;
        const modal = document.getElementById('presentationGradeModal' + studentId);
        if (modal) {
            modal.addEventListener('shown.bs.modal', function() {
                calculatePresentationTotal(studentId);
            });
            // Attach input event listeners
            const inputs = modal.querySelectorAll('.presentation-score');
            inputs.forEach(input => {
                input.addEventListener('input', function() {
                    calculatePresentationTotal(studentId);
                });
            });
            // Handle form submission
            const form = modal.querySelector('form#presentationGradingForm');
            if (form) {
                form.addEventListener('submit', function(e) {
                    e.preventDefault();
                    const formData = new FormData(form);
                    fetch('submit_presentation_grade.php', {
                        method: 'POST',
                        body: formData
                    })
                    .then(response => response.json())
                    .then(data => {
                        const statusDiv = document.getElementById('presentationGradeStatus' + studentId);
                        if (data.status === 'success') {
                            statusDiv.innerHTML = '<span class="text-success">✓ ' + data.message + '</span>';
                        } else {
                            statusDiv.innerHTML = '<span class="text-danger">✗ ' + data.message + '</span>';
                        }
                    })
                    .catch(error => {
                        const statusDiv = document.getElementById('presentationGradeStatus' + studentId);
                        statusDiv.innerHTML = '<span class="text-danger">✗ Error submitting grade</span>';
                    });
                });
            }
        }
    })();
    <?php endforeach; ?>
});
</script>

<?php endforeach; ?> 