<script>
  // Function to toggle the theme
  function toggleTheme() {
    // Toggle the mode classes on the body element
    document.body.classList.toggle('light-mode');
    document.body.classList.toggle('dark-mode');

    // Determine new theme based on body class
    let newTheme = document.body.classList.contains('light-mode') ? 'light' : 'dark';
    // Save the preference in a cookie
    document.cookie = "theme=" + newTheme + "; path=/";

    // Update the dropdown item text and icon
    let themeToggle = document.getElementById('themeToggle');
    if(newTheme === 'light') {
      themeToggle.innerHTML = '<i class="fa fa-moon"></i> Switch to Dark Theme';
    } else {
      themeToggle.innerHTML = '<i class="fa fa-sun"></i> Switch to Light Theme';
    }
  }

  // Attach event listener to the theme toggle dropdown item
  document.getElementById('themeToggle').addEventListener('click', function(e) {
    e.preventDefault();
    toggleTheme();
  });
</script>

<!-- Bootstrap 5.3 JS Bundle with Popper (loaded once at the bottom) -->
<script 
  src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"
></script>

</body>
</html>
