<?php
session_start();
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    include '../config/database.php';

    $username = $_POST['username'];
    $password = $_POST['password'];

    // Fetch the lecturer's details from the lecturer_login table
    $stmt = $pdo->prepare('SELECT id, password FROM lecturer_login WHERE username = ?');
    $stmt->execute([$username]);
    $lecturer = $stmt->fetch();

    if ($lecturer && password_verify($password, $lecturer['password'])) {
        $_SESSION['lecturer_id'] = $lecturer['id'];
        header('Location: index');
        exit;
    } else {
        $error = 'Invalid username or password';
    }
}
include 'lect_header.php';
?>

<div class="container d-flex justify-content-center align-items-center" style="min-height: 100vh;">
    <div class="card p-4" style="max-width: 400px; width: 100%;">
        <h2 class="card-title text-center">Login</h2>
        <?php if (isset($error)): ?>
            <div class="alert alert-danger" role="alert">
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>
        <form method="POST" action="login">
            <div class="mb-3">
                <label for="username" class="form-label">Username</label>
                <input type="text" class="form-control" id="username" name="username" required>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Password</label>
                <input type="password" class="form-control" id="password" name="password" required>
            </div>
            <button type="submit" class="btn btn-primary w-100">Login</button>
        </form>
        <div class="mt-2 text-center">
            <a href="forgot_password.php" class="small">Forgot Password?</a>
        </div>
        <div class="mt-3 text-center">
            <p>Don't have an account? <a href="signup.php">Sign Up</a></p>
        </div>
    </div>
</div>

<?php include 'lect_footer.php'; ?>
