<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Fetch lecturer's first name if logged in
$lecturer_first_name = '';
$lecturer_id = '';

if (isset($_SESSION['lecturer_id'])) {
    include '../config/database.php';
    $lecturer_id = $_SESSION['lecturer_id'];
    $stmt = $pdo->prepare('SELECT name FROM lecturer_login WHERE id = ?');
    $stmt->execute([$lecturer_id]);
    $lecturer = $stmt->fetch();
    $lecturer_first_name = htmlspecialchars(explode(' ', $lecturer['name'])[0]);
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lecturer Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Include Bootstrap Toggle CSS -->
    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
    <link href="style.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="../public/img/sob_logo.png">
    <style>
        /* Custom styling for modal header */
        .modal-header {
            background-color: #002047;
            color: white;
        }
        /* Custom styling for send button */
        .btn-custom-send {
            background-color: #002047;
            color: white;
        }
        .btn-custom-send:hover {
            background-color: #001533;
            /* Slightly darker shade for hover */
            color: white;
        }
        
        /* Grading status indicators for accordion */
        .accordion-button .badge {
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
        }
        
        .accordion-button .badge i {
            font-size: 0.7rem;
        }
        
        /* Ensure badges don't interfere with accordion button text */
        .accordion-button .ms-auto {
            margin-left: auto !important;
        }
        
        /* Mobile-specific styling for grading indicators */
        @media (max-width: 767.98px) {
            .accordion-button {
                padding-right: 3rem;
            }
            
            .accordion-button .badge {
                position: absolute;
                right: 1rem;
                top: 50%;
                transform: translateY(-50%);
            }
        }
    </style>
</head>

<body>
<nav class="navbar navbar-expand-lg navbar-dark" style="background-color: #002047;">
    <div class="container-fluid">
        <a class="navbar-brand fw-bold" href="#">
            <img src="../public/img/sob_logo.png" alt="Logo" width="30" height="30" class="d-inline-block align-top">
            Lecturer Portal
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
            aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <?php if (isset($_SESSION['lecturer_id'])): ?>
            <ul class="navbar-nav ms-auto">
                <li class="nav-item"><a class="nav-link" href="index">Students</a></li>
                <li class="nav-item"><a class="nav-link" href="region">Region</a></li>
                <li class="nav-item"><a class="nav-link" href="mapping">Mapping</a></li>
                <li class="nav-item"><a class="nav-link" href="results">Results</a></li>
                <li class="nav-item">
                    <a class="nav-link" href="#" data-bs-toggle="modal" data-bs-target="#messageModal">Message</a>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
                        data-bs-toggle="dropdown" aria-expanded="false">
                        <?php echo htmlspecialchars($lecturer_first_name); ?>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                        <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
            <?php endif; ?>
        </div>
    </div>
</nav>

<div class="container mt-4 flex-grow-1">

    <?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <?php if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>
    <!-- Your page content starts here -->
    <!-- Send Message Modal -->
    <div class="modal fade" id="messageModal" tabindex="-1" aria-labelledby="messageModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="messageModalLabel">Send Message</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="POST" action="send_message.php">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="recipients" class="form-label">Recipients</label>
                            <select multiple class="form-control" id="recipients" name="recipients[]">
                                <!-- Populated dynamically with PHP -->
                                <?php
                                    if ($lecturer_id) {
                                        $stmt = $pdo->prepare('SELECT user_id, CONCAT(first_name, " ", surname) AS name FROM student_details WHERE lecturer_id = ?');
                                        $stmt->execute([$lecturer_id]);
                                        $students = $stmt->fetchAll();
                                        foreach ($students as $student) {
                                            echo "<option value='{$student['user_id']}'>" . htmlspecialchars($student['name']) . "</option>";
                                        }
                                    }
                                ?>
                            </select>
                        </div>
                        <div class="form-check mb-3">
                            <input type="checkbox" class="form-check-input" id="sendToAll" name="send_to_all" value="1">
                            <label class="form-check-label" for="sendToAll">Send to all students</label>
                        </div>
                        <div class="mb-3">
                            <label for="subject" class="form-label">Subject</label>
                            <input type="text" class="form-control" id="subject" name="subject" required>
                        </div>
                        <div class="mb-3">
                            <label for="message" class="form-label">Message</label>
                            <textarea class="form-control" id="message" name="message" rows="3" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-custom-send">Send</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<!-- The rest of the page content will be injected after this point -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script> -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize all dropdowns
            var dropdownElementList = [].slice.call(document.querySelectorAll('.dropdown-toggle'));
            var dropdownList = dropdownElementList.map(function (dropdownToggleEl) {
                return new bootstrap.Dropdown(dropdownToggleEl);
            });
        });
    </script>
</body>
</html>
