<?php
session_start();
if (!isset($_SESSION['lecturer_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

include '../config/database.php';

$lecturerId = $_SESSION['lecturer_id'];
$data = json_decode(file_get_contents("php://input"), true);

$studentId   = $data['student_id'];
$marks       = $data['marks'];
$grade       = $data['grade'];
$gp          = $data['gp'];
$description = $data['description'];

/*
    Assume your student_results table has columns:
      student_id, lecturer_id, marks, grade, gp, description, status
*/

// First try UPDATE
$stmt = $pdo->prepare('
    UPDATE student_results
    SET marks = ?, grade = ?, gp = ?, description = ?, status = "graded"
    WHERE student_id = ? AND lecturer_id = ?
');
$result = $stmt->execute([$marks, $grade, $gp, $description, $studentId, $lecturerId]);

if ($result && $stmt->rowCount() > 0) {
    echo json_encode(['status' => 'success', 'message' => 'Student graded successfully']);
} else {
    // If no rows were updated, attempt an INSERT
    $insertStmt = $pdo->prepare('
        INSERT INTO student_results (student_id, lecturer_id, marks, grade, gp, description, status)
        VALUES (?, ?, ?, ?, ?, ?, "graded")
    ');
    $insertResult = $insertStmt->execute([$studentId, $lecturerId, $marks, $grade, $gp, $description]);
    if ($insertResult) {
        echo json_encode(['status' => 'success', 'message' => 'Student graded successfully (new record)']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to grade student']);
    }
}
?>
