<?php
// If no students, no reason to create modals
if (!isset($students) || empty($students)) {
    return;
}

// Define the categories and their corresponding criteria
$categories = [
    'Organisation' => [
        [ 'label' => 'Introduction to Presentation',       'max' => 4,  'field' => 'introduction_to_presentation' ],
        [ 'label' => 'Logical Presentation of Information',  'max' => 6,  'field' => 'logical_presentation' ],
    ],
    'Content' => [
        [ 'label' => 'Activities During Internship',          'max' => 10, 'field' => 'activities_during_internship' ],
        [ 'label' => 'Achievements During Internship',        'max' => 30, 'field' => 'achievements_during_internship' ],
        [ 'label' => 'Challenges Faced',                      'max' => 10, 'field' => 'challenges_faced' ],
        [ 'label' => 'How You Overcame Challenges',           'max' => 20, 'field' => 'overcoming_challenges' ],
        [ 'label' => 'Recommendation to Improve Internship',  'max' => 10, 'field' => 'recommendations' ],
    ],
    'Presentation' => [
        [ 'label' => 'Maintain Good Eye Contact',             'max' => 2,  'field' => 'eye_contact' ],
        [ 'label' => 'Use of Clear and Audible Voice',         'max' => 2,  'field' => 'audible_voice' ],
        [ 'label' => 'Information Well Communicated',          'max' => 4,  'field' => 'communication' ],
        [ 'label' => 'Within Assigned Time Limits',            'max' => 2,  'field' => 'time_management' ],
    ],
];

foreach ($students as $student):

    // Query the existing grade for this lecturer & student
    $stmt = $pdo->prepare("
        SELECT *
        FROM pi_student_grades
        WHERE student_id = :student_id
          AND lecturer_id = :lecturer_id
        ORDER BY graded_at DESC
        LIMIT 1
    ");
    $stmt->execute([
        'student_id'  => $student['student_id'],
        'lecturer_id' => $lecturer_id
    ]);
    $existing_scores = $stmt->fetch(PDO::FETCH_ASSOC);

    // Extract the full name from student_details:
    // Combine first_name, other_names (if available), and surname.
    $fullName = trim(
        ($student['first_name'] ?? '') . ' ' . 
        ($student['other_names'] ?? '') . ' ' . 
        ($student['surname'] ?? '')
    );
?>

<div class="modal fade"
     id="gradeModal<?php echo $student['student_id']; ?>"
     tabindex="-1"
     aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-fullscreen-sm-down">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">
          <?php echo htmlspecialchars($fullName); ?>
        </h5>
        <button type="button" class="btn-close"
                data-bs-dismiss="modal"
                aria-label="Close"></button>
      </div>

      <div class="modal-body">
        <!-- The form now submits to submit_grade.php -->
        <form method="POST" action="submit_grade.php" id="gradingForm">
          <!-- Hidden student_id -->
          <input type="hidden"
                 name="student_id"
                 value="<?php echo $student['student_id']; ?>" />

          <div class="table-responsive">
            <table class="table table-bordered">
              <thead class="table-light">
                <tr>
                  <th>Category / Criteria</th>
                  <th>Max Marks</th>
                  <th>Score</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($categories as $categoryName => $criteriaArray): ?>
                  <?php $firstRow = true; ?>
                  <?php foreach ($criteriaArray as $item):
                          $field = $item['field'];
                          $max   = $item['max'];
                          $label = $item['label'];

                          // Display the category name only on the first row of each group
                          if ($firstRow) {
                              $categoryCellContent = "<strong>{$categoryName}</strong><br>{$label}";
                              $firstRow = false;
                          } else {
                              $categoryCellContent = $label;
                          }
                  ?>
                  <tr>
                    <td><?php echo $categoryCellContent; ?></td>
                    <td><?php echo $max; ?></td>
                    <td>
                      <input
                        type="number"
                        name="<?php echo $field; ?>"
                        class="form-control"
                        min="0"
                        max="<?php echo $max; ?>"
                        value="<?php echo $existing_scores[$field] ?? ''; ?>"
                        required
                      />
                    </td>
                  </tr>
                  <?php endforeach; ?>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div><!-- /.table-responsive -->

          <!-- Comments Section -->
          <div class="mb-3">
            <label class="form-label"><strong>Comments (Optional)</strong></label>
            <textarea
              name="comments"
              class="form-control"
              rows="3"
            ><?php echo $existing_scores['comments'] ?? ''; ?></textarea>
          </div>

          <!-- Submit Button -->
          <button type="submit" name="grade_student" class="btn btn-success w-100 mt-2">
            <?php echo ($existing_scores) ? "Update Grade" : "Submit Grade"; ?>
          </button>
        </form>
      </div><!-- /.modal-body -->

    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<?php endforeach; ?>
